/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.miaixz.bus.core.io.file.PathResolve;
import org.miaixz.bus.core.io.file.visitor.MoveVisitor;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class PathMover {
    private final Path src;
    private final Path target;
    private final CopyOption[] options;

    public PathMover(Path src, Path target, CopyOption[] options) {
        Assert.notNull(target, "Src path must be not null !", new Object[0]);
        if (!PathResolve.exists(src, false)) {
            throw new IllegalArgumentException("Src path is not exist!");
        }
        this.src = src;
        this.target = Assert.notNull(target, "Target path must be not null !", new Object[0]);
        this.options = ObjectKit.defaultIfNull(options, new CopyOption[0]);
    }

    public static PathMover of(Path src, Path target, boolean isOverride) {
        CopyOption[] copyOptionArray;
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        return PathMover.of(src, target, copyOptionArray);
    }

    public static PathMover of(Path src, Path target, CopyOption[] options) {
        return new PathMover(src, target, options);
    }

    private static void walkMove(Path src, Path target, CopyOption ... options) {
        try {
            Files.walkFileTree(src, new MoveVisitor(src, target, options));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public Path move() throws IllegalArgumentException {
        Path src = this.src;
        Path target = this.target;
        CopyOption[] options = this.options;
        if (PathResolve.isSub(src, target)) {
            if (Files.exists(target, new LinkOption[0]) && PathResolve.equals(src, target)) {
                return target;
            }
            throw new IllegalArgumentException(StringKit.format("Target [{}] is sub path of src [{}]!", target, src));
        }
        if (PathResolve.isDirectory(target)) {
            target = target.resolve(src.getFileName());
        }
        PathResolve.mkParentDirs(target);
        try {
            return Files.move(src, target, options);
        }
        catch (IOException e) {
            if (e instanceof FileAlreadyExistsException || e instanceof AccessDeniedException) {
                throw new InternalException(e);
            }
            PathMover.walkMove(src, target, options);
            PathResolve.del(src);
            return target;
        }
    }

    public Path moveContent() {
        Path src = this.src;
        if (PathResolve.isExistsAndNotDirectory(this.target, false)) {
            return this.move();
        }
        Path target = this.target;
        if (PathResolve.isExistsAndNotDirectory(target, false)) {
            throw new IllegalArgumentException("Can not move dir content to a file");
        }
        if (PathResolve.equals(src, target)) {
            return target;
        }
        CopyOption[] options = this.options;
        PathResolve.mkParentDirs(target);
        PathMover.walkMove(src, target, options);
        return target;
    }
}

