/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Console {
    public static void log() {
        System.out.println();
    }

    public static void log(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.log(e, e.getMessage(), new Object[0]);
        } else {
            Console.log("{}", obj);
        }
    }

    public static void log(Object obj1, Object ... otherObjs) {
        if (ArrayKit.isEmpty(otherObjs)) {
            Console.log(obj1);
        } else {
            Console.log(Console.buildTemplateSplitBySpace(otherObjs.length + 1), ArrayKit.insert(otherObjs, 0, new Object[]{obj1}));
        }
    }

    public static void log(String template, Object ... values) {
        if (ArrayKit.isEmpty(values) || StringKit.contains((CharSequence)template, "{}")) {
            Console.logInternal(template, values);
        } else {
            Console.logInternal(Console.buildTemplateSplitBySpace(values.length + 1), ArrayKit.insert(values, 0, new Object[]{template}));
        }
    }

    public static void log(Throwable t, String template, Object ... values) {
        System.out.println(StringKit.format(template, values));
        if (null != t) {
            t.printStackTrace(System.out);
            System.out.flush();
        }
    }

    private static void logInternal(String template, Object ... values) {
        Console.log(null, template, values);
    }

    public static void table(Table consoleTable) {
        Console.print(consoleTable.toString());
    }

    public static void print(Object obj) {
        Console.print("{}", obj);
    }

    public static void print(Object obj1, Object ... otherObjs) {
        if (ArrayKit.isEmpty(otherObjs)) {
            Console.print(obj1);
        } else {
            Console.print(Console.buildTemplateSplitBySpace(otherObjs.length + 1), ArrayKit.insert(otherObjs, 0, new Object[]{obj1}));
        }
    }

    public static void print(String template, Object ... values) {
        if (ArrayKit.isEmpty(values) || StringKit.contains((CharSequence)template, "{}")) {
            Console.printInternal(template, values);
        } else {
            Console.printInternal(Console.buildTemplateSplitBySpace(values.length + 1), ArrayKit.insert(values, 0, new Object[]{template}));
        }
    }

    public static void printProgress(char showChar, int len) {
        Console.print("{}{}", Character.valueOf('\r'), StringKit.repeat(showChar, len));
    }

    public static void printProgress(char showChar, int totalLen, double rate) {
        Assert.isTrue(rate >= 0.0 && rate <= 1.0, "Rate must between 0 and 1 (both include)", new Object[0]);
        Console.printProgress(showChar, (int)((double)totalLen * rate));
    }

    private static void printInternal(String template, Object ... values) {
        System.out.print(StringKit.format(template, values));
    }

    public static void error() {
        System.err.println();
    }

    public static void error(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.error(e, e.getMessage(), new Object[0]);
        } else {
            Console.error("{}", obj);
        }
    }

    public static void error(Object obj1, Object ... otherObjs) {
        if (ArrayKit.isEmpty(otherObjs)) {
            Console.error(obj1);
        } else {
            Console.error(Console.buildTemplateSplitBySpace(otherObjs.length + 1), ArrayKit.insert(otherObjs, 0, new Object[]{obj1}));
        }
    }

    public static void error(String template, Object ... values) {
        if (ArrayKit.isEmpty(values) || StringKit.contains((CharSequence)template, "{}")) {
            Console.errorInternal(template, values);
        } else {
            Console.errorInternal(Console.buildTemplateSplitBySpace(values.length + 1), ArrayKit.insert(values, 0, new Object[]{template}));
        }
    }

    public static void error(Throwable t, String template, Object ... values) {
        System.err.println(StringKit.format(template, values));
        if (null != t) {
            t.printStackTrace(System.err);
            System.err.flush();
        }
    }

    private static void errorInternal(String template, Object ... values) {
        Console.error(null, template, values);
    }

    public static Scanner scanner() {
        return new Scanner(System.in);
    }

    public static String input() {
        return Console.scanner().nextLine();
    }

    public static String where() {
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[1];
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        String fileName = stackTraceElement.getFileName();
        Integer lineNumber = stackTraceElement.getLineNumber();
        return String.format("%s.%s(%s:%s)", className, methodName, fileName, lineNumber);
    }

    public static Integer lineNumber() {
        return new Throwable().getStackTrace()[1].getLineNumber();
    }

    private static String buildTemplateSplitBySpace(int count) {
        return StringKit.repeatAndJoin("{}", count, " ");
    }

    public static class Table {
        private static final char ROW_LINE = '\uff0d';
        private static final char COLUMN_LINE = '|';
        private static final char SPACE = '\u3000';
        private static final char LF = '\n';
        private final List<List<String>> headerList = new ArrayList<List<String>>();
        private final List<List<String>> bodyList = new ArrayList<List<String>>();
        private boolean isSBCMode = true;
        private List<Integer> columnCharNumber;

        public static Table of() {
            return new Table();
        }

        public Table setSBCMode(boolean isSBCMode) {
            this.isSBCMode = isSBCMode;
            return this;
        }

        public Table addHeader(String ... titles) {
            if (this.columnCharNumber == null) {
                this.columnCharNumber = new ArrayList<Integer>(Collections.nCopies(titles.length, 0));
            }
            ArrayList<String> l = new ArrayList<String>();
            this.fillColumns(l, titles);
            this.headerList.add(l);
            return this;
        }

        public Table addBody(String ... values) {
            ArrayList<String> l = new ArrayList<String>();
            this.bodyList.add(l);
            this.fillColumns(l, values);
            return this;
        }

        private void fillColumns(List<String> l, String[] columns) {
            for (int i = 0; i < columns.length; ++i) {
                String column = StringKit.toString(columns[i]);
                if (this.isSBCMode) {
                    column = Convert.toSBC(column);
                }
                l.add(column);
                int width = column.length();
                if (width <= this.columnCharNumber.get(i)) continue;
                this.columnCharNumber.set(i, width);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.fillBorder(sb);
            this.fillRows(sb, this.headerList);
            this.fillBorder(sb);
            this.fillRows(sb, this.bodyList);
            this.fillBorder(sb);
            return sb.toString();
        }

        private void fillRows(StringBuilder sb, List<List<String>> list) {
            for (List<String> row : list) {
                sb.append('|');
                this.fillRow(sb, row);
                sb.append('\n');
            }
        }

        private void fillRow(StringBuilder sb, List<String> row) {
            int size = row.size();
            for (int i = 0; i < size; ++i) {
                String value = row.get(i);
                sb.append('\u3000');
                sb.append(value);
                int length = value.length();
                int sbcCount = this.sbcCount(value);
                if (sbcCount % 2 == 1) {
                    sb.append(' ');
                }
                sb.append('\u3000');
                int maxLength = this.columnCharNumber.get(i);
                for (int j = 0; j < maxLength - length + sbcCount / 2; ++j) {
                    sb.append('\u3000');
                }
                sb.append('|');
            }
        }

        private void fillBorder(StringBuilder sb) {
            sb.append('+');
            for (Integer width : this.columnCharNumber) {
                sb.append(StringKit.repeat('\uff0d', width + 2));
                sb.append('+');
            }
            sb.append('\n');
        }

        public void print() {
            Console.print(this.toString());
        }

        private int sbcCount(String value) {
            int count = 0;
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) >= '\u007f') continue;
                ++count;
            }
            return count;
        }
    }
}

