/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang;

import java.time.DayOfWeek;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import org.miaixz.bus.core.lang.Assert;

public class Fields {
    public static final String NORM_YEAR = "yyyy";
    public static final String NORM_MONTH = "yyyy-MM";
    public static final String SIMPLE_MONTH = "yyyyMM";
    public static final String NORM_DATE = "yyyy-MM-dd";
    public static final String NORM_TIME = "HH:mm:ss";
    public static final String NORM_DATETIME_MINUTE = "yyyy-MM-dd HH:mm";
    public static final String NORM_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String NORM_DATETIME_MS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String NORM_DATETIME_COMMA_MS = "yyyy-MM-dd HH:mm:ss,SSS";
    public static final String CN_DATE = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String CN_DATE_TIME = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2";
    public static final String PURE_DATE = "yyyyMMdd";
    public static final String PURE_TIME = "HHmmss";
    public static final String PURE_DATETIME = "yyyyMMddHHmmss";
    public static final String PURE_DATETIME_MS = "yyyyMMddHHmmssSSS";
    public static final String PURE_DATETIME_TIP_PATTERN = "yyyyMMddHHmmss.SSS";
    public static final String HTTP_DATETIME = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String JDK_DATETIME = "EEE MMM dd HH:mm:ss zzz yyyy";
    public static final String ISO8601 = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String ISO8601_MS = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String UTC = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String ISO8601_WITH_ZONE_OFFSET = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String ISO8601_WITH_XXX_OFFSET = "yyyy-MM-dd'T'HH:mm:ssXXX";
    public static final String UTC_MS = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String ISO8601_MS_WITH_ZONE_OFFSET = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String ISO8601_MS_WITH_XXX_OFFSET = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    public static enum Type {
        ERA(0),
        YEAR(1),
        MONTH(2),
        WEEK_OF_YEAR(3),
        WEEK_OF_MONTH(4),
        DAY_OF_MONTH(5),
        DAY_OF_YEAR(6),
        DAY_OF_WEEK(7),
        DAY_OF_WEEK_IN_MONTH(8),
        AM_PM(9),
        HOUR(10),
        HOUR_OF_DAY(11),
        MINUTE(12),
        SECOND(13),
        MILLISECOND(14);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type of(int calendarPartIntValue) {
            switch (calendarPartIntValue) {
                case 0: {
                    return ERA;
                }
                case 1: {
                    return YEAR;
                }
                case 2: {
                    return MONTH;
                }
                case 3: {
                    return WEEK_OF_YEAR;
                }
                case 4: {
                    return WEEK_OF_MONTH;
                }
                case 5: {
                    return DAY_OF_MONTH;
                }
                case 6: {
                    return DAY_OF_YEAR;
                }
                case 7: {
                    return DAY_OF_WEEK;
                }
                case 8: {
                    return DAY_OF_WEEK_IN_MONTH;
                }
                case 9: {
                    return AM_PM;
                }
                case 10: {
                    return HOUR;
                }
                case 11: {
                    return HOUR_OF_DAY;
                }
                case 12: {
                    return MINUTE;
                }
                case 13: {
                    return SECOND;
                }
                case 14: {
                    return MILLISECOND;
                }
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Modify {
        TRUNCATE,
        ROUND,
        CEILING;

    }

    public static enum Units {
        MS(1L),
        SECOND(1000L),
        MINUTE(SECOND.getMillis() * 60L),
        HOUR(MINUTE.getMillis() * 60L),
        DAY(HOUR.getMillis() * 24L),
        WEEK(DAY.getMillis() * 7L);

        private final long millis;

        private Units(long millis) {
            this.millis = millis;
        }

        public static Units of(ChronoUnit unit) {
            switch (unit) {
                case MICROS: {
                    return MS;
                }
                case SECONDS: {
                    return SECOND;
                }
                case MINUTES: {
                    return MINUTE;
                }
                case HOURS: {
                    return HOUR;
                }
                case DAYS: {
                    return DAY;
                }
                case WEEKS: {
                    return WEEK;
                }
            }
            return null;
        }

        public static ChronoUnit toChronoUnit(Units unit) {
            switch (unit.ordinal()) {
                case 0: {
                    return ChronoUnit.MICROS;
                }
                case 1: {
                    return ChronoUnit.SECONDS;
                }
                case 2: {
                    return ChronoUnit.MINUTES;
                }
                case 3: {
                    return ChronoUnit.HOURS;
                }
                case 4: {
                    return ChronoUnit.DAYS;
                }
                case 5: {
                    return ChronoUnit.WEEKS;
                }
            }
            return null;
        }

        public long getMillis() {
            return this.millis;
        }

        public ChronoUnit toChronoUnit() {
            return Units.toChronoUnit(this);
        }
    }

    public static enum Month {
        JANUARY(0),
        FEBRUARY(1),
        MARCH(2),
        APRIL(3),
        MAY(4),
        JUNE(5),
        JULY(6),
        AUGUST(7),
        SEPTEMBER(8),
        OCTOBER(9),
        NOVEMBER(10),
        DECEMBER(11),
        UNDECIMBER(12);

        private static final Month[] ENUMS;
        private final int value;

        private Month(int value) {
            this.value = value;
        }

        public static Month of(int calendarMonthIntValue) {
            if (calendarMonthIntValue >= ENUMS.length || calendarMonthIntValue < 0) {
                return null;
            }
            return ENUMS[calendarMonthIntValue];
        }

        public static Month of(String name) throws IllegalArgumentException {
            if (null != name && name.length() > 2) {
                switch (Character.toLowerCase(name.charAt(0))) {
                    case 'a': {
                        switch (Character.toLowerCase(name.charAt(1))) {
                            case 'p': {
                                return APRIL;
                            }
                            case 'u': {
                                return AUGUST;
                            }
                        }
                        break;
                    }
                    case 'j': {
                        if (Character.toLowerCase(name.charAt(1)) == 'a') {
                            return JANUARY;
                        }
                        switch (Character.toLowerCase(name.charAt(2))) {
                            case 'n': {
                                return JUNE;
                            }
                            case 'l': {
                                return JULY;
                            }
                        }
                        break;
                    }
                    case 'f': {
                        return FEBRUARY;
                    }
                    case 'm': {
                        switch (Character.toLowerCase(name.charAt(2))) {
                            case 'r': {
                                return MARCH;
                            }
                            case 'y': {
                                return MAY;
                            }
                        }
                        break;
                    }
                    case 's': {
                        return SEPTEMBER;
                    }
                    case 'o': {
                        return OCTOBER;
                    }
                    case 'n': {
                        return NOVEMBER;
                    }
                    case 'd': {
                        return DECEMBER;
                    }
                }
            }
            throw new IllegalArgumentException("Invalid Month name: " + name);
        }

        public static Month of(java.time.Month month) {
            return Month.of(month.ordinal());
        }

        public static int getLastDay(int month, boolean isLeapYear) {
            Month of = Month.of(month);
            Assert.notNull(of, "Invalid Month base 0: " + month, new Object[0]);
            return of.getLastDay(isLeapYear);
        }

        public int getValue() {
            return this.value;
        }

        public int getValueBaseOne() {
            Assert.isFalse(this == UNDECIMBER, "Unsupported UNDECIMBER Field", new Object[0]);
            return this.getValue() + 1;
        }

        public int getLastDay(boolean isLeapYear) {
            switch (this.ordinal()) {
                case 1: {
                    return isLeapYear ? 29 : 28;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: {
                    return 30;
                }
            }
            return 31;
        }

        public java.time.Month toJdkMonth() {
            return java.time.Month.of(this.getValueBaseOne());
        }

        public String getDisplayName(TextStyle style) {
            return this.getDisplayName(style, Locale.getDefault());
        }

        public String getDisplayName(TextStyle style, Locale locale) {
            return this.toJdkMonth().getDisplayName(style, locale);
        }

        static {
            ENUMS = Month.values();
        }
    }

    public static enum Quarter {
        Q1(1),
        Q2(2),
        Q3(3),
        Q4(4);

        private final int value;

        private Quarter(int value) {
            this.value = value;
        }

        public static Quarter of(int intValue) {
            switch (intValue) {
                case 1: {
                    return Q1;
                }
                case 2: {
                    return Q2;
                }
                case 3: {
                    return Q3;
                }
                case 4: {
                    return Q4;
                }
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Week {
        SUNDAY(1),
        MONDAY(2),
        TUESDAY(3),
        WEDNESDAY(4),
        THURSDAY(5),
        FRIDAY(6),
        SATURDAY(7);

        private static final Week[] ENUMS;
        private final int value;

        private Week(int value) {
            this.value = value;
        }

        public static Week of(int calendarWeekIntValue) {
            if (calendarWeekIntValue > ENUMS.length || calendarWeekIntValue < 1) {
                return null;
            }
            return ENUMS[calendarWeekIntValue - 1];
        }

        public static Week of(String name) throws IllegalArgumentException {
            if (null != name && name.length() > 1) {
                switch (Character.toLowerCase(name.charAt(0))) {
                    case 'm': {
                        return MONDAY;
                    }
                    case 'w': {
                        return WEDNESDAY;
                    }
                    case 'f': {
                        return FRIDAY;
                    }
                    case 't': {
                        switch (Character.toLowerCase(name.charAt(1))) {
                            case 'u': {
                                return TUESDAY;
                            }
                            case 'h': {
                                return THURSDAY;
                            }
                        }
                        break;
                    }
                    case 's': {
                        switch (Character.toLowerCase(name.charAt(1))) {
                            case 'a': {
                                return SATURDAY;
                            }
                            case 'u': {
                                return SUNDAY;
                            }
                        }
                    }
                }
            }
            throw new IllegalArgumentException("Invalid Week name: " + name);
        }

        public static Week of(DayOfWeek dayOfWeek) {
            Assert.notNull(dayOfWeek);
            int week = dayOfWeek.getValue() + 1;
            if (8 == week) {
                week = 1;
            }
            return Week.of(week);
        }

        public int getValue() {
            return this.value;
        }

        public int getIso8601Value() {
            int iso8601IntValue = this.getValue() - 1;
            if (0 == iso8601IntValue) {
                iso8601IntValue = 7;
            }
            return iso8601IntValue;
        }

        public String toChinese() {
            return this.toChinese("\u661f\u671f");
        }

        public String toChinese(String weekNamePre) {
            switch (this.ordinal()) {
                case 0: {
                    return weekNamePre + "\u65e5";
                }
                case 1: {
                    return weekNamePre + "\u4e00";
                }
                case 2: {
                    return weekNamePre + "\u4e8c";
                }
                case 3: {
                    return weekNamePre + "\u4e09";
                }
                case 4: {
                    return weekNamePre + "\u56db";
                }
                case 5: {
                    return weekNamePre + "\u4e94";
                }
                case 6: {
                    return weekNamePre + "\u516d";
                }
            }
            return null;
        }

        public DayOfWeek toJdkDayOfWeek() {
            return DayOfWeek.of(this.getIso8601Value());
        }

        static {
            ENUMS = Week.values();
        }
    }
}

