/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.loader.Loader;
import org.miaixz.bus.core.lang.loader.Loaders;
import org.miaixz.bus.core.lang.loader.StdLoader;
import org.miaixz.bus.core.xyz.StringKit;

public class NatLoader
extends StdLoader
implements Loader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Resource> load(String path, Class<?> clazz) throws IOException {
        String filename;
        if (null == path || !path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String string = filename = parts.length > 1 ? parts[parts.length - 1] : null;
        if (null == filename || filename.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        File dir = new File(System.getProperty("java.io.tmpdir"), StringKit.toString(System.nanoTime()));
        if (!dir.mkdir()) {
            throw new IOException("Failed to create temp directory " + dir.getName());
        }
        dir.deleteOnExit();
        File file = new File(dir, filename);
        Class aClass = null == clazz ? Loaders.class : clazz;
        try (InputStream is = aClass.getResourceAsStream(path);){
            Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            file.delete();
            throw e;
        }
        catch (NullPointerException e) {
            file.delete();
            throw new FileNotFoundException("File " + path + " was not found inside JAR.");
        }
        try {
            System.load(file.getAbsolutePath());
        }
        finally {
            if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
                file.delete();
            } else {
                file.deleteOnExit();
            }
        }
        return null;
    }
}

