/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.loader.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.miaixz.bus.core.cache.SimpleCache;
import org.miaixz.bus.core.io.resource.MultiResource;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.loader.spi.AbsServiceLoader;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.ResourceKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ListServiceLoader<S>
extends AbsServiceLoader<S> {
    private final List<String> serviceNames = new ArrayList<String>();
    private final SimpleCache<String, S> serviceCache = new SimpleCache(new HashMap());

    public ListServiceLoader(String pathPrefix, Class<S> serviceClass, ClassLoader classLoader, Charset charset) {
        super(pathPrefix, serviceClass, classLoader, charset);
        this.load();
    }

    public static <S> ListServiceLoader<S> of(Class<S> serviceClass) {
        return ListServiceLoader.of(serviceClass, null);
    }

    public static <S> ListServiceLoader<S> of(Class<S> serviceClass, ClassLoader classLoader) {
        return ListServiceLoader.of("META-INF/services", serviceClass, classLoader);
    }

    public static <S> ListServiceLoader<S> of(String pathPrefix, Class<S> serviceClass, ClassLoader classLoader) {
        return new ListServiceLoader<S>(pathPrefix, serviceClass, classLoader, null);
    }

    @Override
    public void load() {
        MultiResource resources = ResourceKit.getResources(this.pathPrefix + this.serviceClass.getName(), this.classLoader);
        for (Resource resource : resources) {
            this.parse(resource);
        }
    }

    @Override
    public int size() {
        return this.serviceNames.size();
    }

    @Override
    public List<String> getServiceNames() {
        return ListKit.view(this.serviceNames);
    }

    public Class<S> getServiceClass(int index) {
        String serviceClassName = this.serviceNames.get(index);
        if (StringKit.isBlank(serviceClassName)) {
            return null;
        }
        return this.getServiceClass(serviceClassName);
    }

    @Override
    public Class<S> getServiceClass(String serviceName) {
        return ClassKit.loadClass(serviceName);
    }

    public S getService(int index) {
        String serviceClassName = this.serviceNames.get(index);
        if (null == serviceClassName) {
            return null;
        }
        return this.getService(serviceClassName);
    }

    @Override
    public S getService(String serviceName) {
        return (S)this.serviceCache.get(serviceName, () -> this.createService(serviceName));
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            private final Iterator<String> nameIter;
            {
                this.nameIter = ListServiceLoader.this.serviceNames.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.nameIter.hasNext();
            }

            @Override
            public S next() {
                return ListServiceLoader.this.getService(this.nameIter.next());
            }
        };
    }

    private void parse(Resource resource) {
        try (BufferedReader reader = resource.getReader(this.charset);){
            int lc = 1;
            while (lc >= 0) {
                lc = this.parseLine(resource, reader, lc);
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private int parseLine(Resource resource, BufferedReader reader, int lineNo) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return -1;
        }
        int ci = line.indexOf(35);
        if (ci >= 0) {
            line = line.substring(0, ci);
        }
        if (!(line = StringKit.trim(line)).isEmpty()) {
            this.checkLine(resource, lineNo, line);
            List<String> names = this.serviceNames;
            if (!this.serviceCache.containsKey(line) && !names.contains(line)) {
                names.add(line);
            }
        }
        return lineNo + 1;
    }

    private void checkLine(Resource resource, int lineNo, String line) {
        int cp;
        if (StringKit.containsBlank(line)) {
            this.fail(resource, lineNo, "Illegal configuration-file syntax");
        }
        if (!Character.isJavaIdentifierStart(cp = line.codePointAt(0))) {
            this.fail(resource, lineNo, "Illegal provider-class name: " + line);
        }
        int n = line.length();
        for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
            cp = line.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
            this.fail(resource, lineNo, "Illegal provider-class name: " + line);
        }
    }

    private void fail(Resource resource, int lineNo, String msg) {
        throw new InternalException(String.valueOf(this.serviceClass) + ":" + String.valueOf(resource.getUrl()) + ":" + lineNo + ": " + msg);
    }

    private S createService(String serviceClassName) {
        return (S)ReflectKit.newInstance(ClassKit.loadClass(serviceClassName), new Object[0]);
    }
}

