/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.loader.spi;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.miaixz.bus.core.cache.SimpleCache;
import org.miaixz.bus.core.lang.loader.spi.AbsServiceLoader;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.ResourceKit;
import org.miaixz.bus.core.xyz.StringKit;

public class MapServiceLoader<S>
extends AbsServiceLoader<S> {
    private static final String PREFIX = "META-INF/bus/";
    private final SimpleCache<String, S> serviceCache = new SimpleCache(new HashMap());
    private Properties serviceProperties;

    public MapServiceLoader(String pathPrefix, Class<S> serviceClass, ClassLoader classLoader, Charset charset) {
        super(pathPrefix, serviceClass, classLoader, charset);
        this.load();
    }

    public static <S> MapServiceLoader<S> of(Class<S> serviceClass) {
        return MapServiceLoader.of(serviceClass, null);
    }

    public static <S> MapServiceLoader<S> of(Class<S> serviceClass, ClassLoader classLoader) {
        return MapServiceLoader.of(PREFIX, serviceClass, classLoader);
    }

    public static <S> MapServiceLoader<S> of(String pathPrefix, Class<S> serviceClass, ClassLoader classLoader) {
        return new MapServiceLoader<S>(pathPrefix, serviceClass, classLoader, null);
    }

    @Override
    public void load() {
        Properties properties = new Properties();
        ResourceKit.loadAllTo(properties, this.pathPrefix + this.serviceClass.getName(), this.classLoader, this.charset, false);
        this.serviceProperties = properties;
    }

    @Override
    public int size() {
        return this.serviceProperties.size();
    }

    @Override
    public List<String> getServiceNames() {
        return ListKit.view(this.serviceCache.keys());
    }

    @Override
    public Class<S> getServiceClass(String serviceName) {
        String serviceClassName = this.serviceProperties.getProperty(serviceName);
        if (StringKit.isBlank(serviceClassName)) {
            return null;
        }
        return ClassKit.loadClass(serviceClassName);
    }

    @Override
    public S getService(String serviceName) {
        return (S)this.serviceCache.get(serviceName, () -> this.createService(serviceName));
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            private final Iterator<String> nameIter;
            {
                this.nameIter = MapServiceLoader.this.serviceProperties.stringPropertyNames().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.nameIter.hasNext();
            }

            @Override
            public S next() {
                return MapServiceLoader.this.getService(this.nameIter.next());
            }
        };
    }

    private S createService(String serviceName) {
        return ReflectKit.newInstance(this.getServiceClass(serviceName), new Object[0]);
    }
}

