/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.reflect.kotlin;

import java.lang.reflect.Method;
import java.util.Objects;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.MethodKit;

public class KotlinParameter {
    private static final Method METHOD_GET_NAME;
    private static final Method METHOD_GET_TYPE;
    private static final Method METHOD_GET_JAVA_TYPE;
    private final String name;
    private final Class<?> type;

    public KotlinParameter(Object kParameterInstance) {
        this.name = (String)MethodKit.invoke(kParameterInstance, METHOD_GET_NAME, new Object[0]);
        Object kType = MethodKit.invoke(kParameterInstance, METHOD_GET_TYPE, new Object[0]);
        this.type = (Class)MethodKit.invoke(kType, METHOD_GET_JAVA_TYPE, new Object[0]);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KotlinParameter that = (KotlinParameter)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return "KotlinParameter{name='" + this.name + "', type=" + String.valueOf(this.type) + "}";
    }

    static {
        Class kParameterClass = ClassKit.loadClass("kotlin.reflect.KParameter");
        METHOD_GET_NAME = MethodKit.getMethod(kParameterClass, "getName", new Class[0]);
        METHOD_GET_TYPE = MethodKit.getMethod(kParameterClass, "getType", new Class[0]);
        Class kTypeClass = ClassKit.loadClass("kotlin.reflect.jvm.internal.KTypeImpl");
        METHOD_GET_JAVA_TYPE = MethodKit.getMethod(kTypeClass, "getJavaType", new Class[0]);
    }
}

