/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.thread;

import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.thread.GlobalThreadPool;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.ThreadKit;

public class RetryableTask<T> {
    private final Supplier<T> sup;
    private final BiPredicate<T, Throwable> predicate;
    private T result;
    private long maxAttempts = 3L;
    private Duration delay = Duration.ofSeconds(1L);

    private RetryableTask(Supplier<T> sup, BiPredicate<T, Throwable> predicate) {
        Assert.notNull(sup, "task parameter cannot be null", new Object[0]);
        Assert.notNull(predicate, "predicate parameter cannot be null", new Object[0]);
        this.predicate = predicate;
        this.sup = sup;
    }

    @SafeVarargs
    public static <T> RetryableTask<T> retryForExceptions(Runnable run, Class<? extends Throwable> ... ths) {
        return RetryableTask.retryForExceptions(() -> {
            run.run();
            return null;
        }, ths);
    }

    @SafeVarargs
    public static <T> RetryableTask<T> retryForExceptions(Supplier<T> sup, Class<? extends Throwable> ... ths) {
        Assert.isTrue(ths.length != 0, "exs cannot be empty", new Object[0]);
        BiPredicate<Object, Throwable> strategy = (t, e) -> {
            if (ObjectKit.isNotNull(e)) {
                return Arrays.stream(ths).anyMatch(ex -> ex.isAssignableFrom(e.getClass()));
            }
            return false;
        };
        return new RetryableTask<Object>(sup, strategy);
    }

    public static <T> RetryableTask<T> retryForPredicate(Runnable run, BiPredicate<T, Throwable> predicate) {
        return RetryableTask.retryForPredicate(() -> {
            run.run();
            return null;
        }, predicate);
    }

    public static <T> RetryableTask<T> retryForPredicate(Supplier<T> sup, BiPredicate<T, Throwable> predicate) {
        return new RetryableTask<T>(sup, predicate);
    }

    public RetryableTask<T> maxAttempts(long maxAttempts) {
        Assert.isTrue(this.maxAttempts > 0L, "maxAttempts must be greater than 0", new Object[0]);
        this.maxAttempts = maxAttempts;
        return this;
    }

    public RetryableTask<T> delay(Duration delay) {
        Assert.notNull(this.delay, "delay parameter cannot be null", new Object[0]);
        this.delay = delay;
        return this;
    }

    public Optional<T> get() {
        return Optional.ofNullable(this.result);
    }

    public CompletableFuture<RetryableTask<T>> asyncExecute() {
        return CompletableFuture.supplyAsync(this::doExecute, GlobalThreadPool.getExecutor());
    }

    public RetryableTask<T> execute() {
        return this.doExecute();
    }

    private RetryableTask<T> doExecute() {
        Throwable th = null;
        while (--this.maxAttempts >= 0L) {
            try {
                this.result = this.sup.get();
            }
            catch (Throwable t) {
                th = t;
            }
            if (!this.predicate.test(this.result, th)) break;
            ThreadKit.sleep(this.delay.toMillis());
        }
        return this;
    }
}

