/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.net.tls;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.StringKit;

public class TrustAnyTrustManager
extends X509ExtendedTrustManager {
    public static final TrustAnyTrustManager INSTANCE = new TrustAnyTrustManager();
    public static final X509TrustManager[] TRUST_ANYS = new X509TrustManager[]{INSTANCE};
    private static final X509Certificate[] EMPTY_X509_CERTIFICATE_ARRAY = new X509Certificate[0];

    public static X509TrustManager getDefaultTrustManager() {
        return TrustAnyTrustManager.getTrustManager(null, null);
    }

    public static X509TrustManager getTrustManager(KeyStore keyStore, Provider provider) {
        return TrustAnyTrustManager.getTrustManager(keyStore, null, provider);
    }

    public static X509TrustManager getTrustManager(KeyStore keyStore, String algorithm, Provider provider) {
        TrustManager[] tms;
        for (TrustManager tm : tms = TrustAnyTrustManager.getTrustManagers(keyStore, algorithm, provider)) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        return null;
    }

    public static TrustManager[] getDefaultTrustManagers() {
        return TrustAnyTrustManager.getTrustManagers(null, null, null);
    }

    public static TrustManager[] getTrustManagers(KeyStore keyStore, String algorithm, Provider provider) {
        TrustManagerFactory tmf;
        if (StringKit.isEmpty(algorithm)) {
            algorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        try {
            tmf = null == provider ? TrustManagerFactory.getInstance(algorithm) : TrustManagerFactory.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalException(e);
        }
        try {
            tmf.init(keyStore);
        }
        catch (KeyStoreException e) {
            throw new InternalException(e);
        }
        return tmf.getTrustManagers();
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return EMPTY_X509_CERTIFICATE_ARRAY;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) {
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
    }
}

