/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xml;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xml.SAXParserFactory;
import org.miaixz.bus.core.xml.XXE;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSaxReader {
    private final javax.xml.parsers.SAXParserFactory factory;
    private final InputSource source;

    public XmlSaxReader(javax.xml.parsers.SAXParserFactory factory, InputSource source) {
        this.factory = factory;
        this.source = source;
    }

    public static XmlSaxReader of(InputSource source) {
        return XmlSaxReader.of(SAXParserFactory.getFactory(), source);
    }

    public static XmlSaxReader of(javax.xml.parsers.SAXParserFactory factory, InputSource source) {
        return new XmlSaxReader(factory, source);
    }

    public void read(ContentHandler contentHandler) {
        try {
            SAXParser parse = this.factory.newSAXParser();
            if (contentHandler instanceof DefaultHandler) {
                parse.parse(this.source, (DefaultHandler)contentHandler);
                return;
            }
            XMLReader reader = XXE.disableXXE(parse.getXMLReader());
            reader.setContentHandler(contentHandler);
            reader.parse(this.source);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new InternalException(e);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }
}

