/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.miaixz.bus.core.center.date.Almanac;
import org.miaixz.bus.core.center.date.Between;
import org.miaixz.bus.core.center.date.Boundary;
import org.miaixz.bus.core.center.date.Calendars;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.center.date.Formatter;
import org.miaixz.bus.core.center.date.Resolver;
import org.miaixz.bus.core.center.date.StopWatch;
import org.miaixz.bus.core.center.date.Zodiac;
import org.miaixz.bus.core.center.date.format.CustomFormat;
import org.miaixz.bus.core.center.date.format.FormatPeriod;
import org.miaixz.bus.core.center.date.format.parser.NormalDateParser;
import org.miaixz.bus.core.center.date.format.parser.PositionDateParser;
import org.miaixz.bus.core.center.date.format.parser.RegisterDateParser;
import org.miaixz.bus.core.center.date.printer.FormatPrinter;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Fields;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.CompareKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.StringKit;

public class DateKit
extends Calendars {
    public static DateTime now() {
        return new DateTime();
    }

    public static DateTime today() {
        return new DateTime(DateKit.beginOfDay(Calendar.getInstance()));
    }

    public static DateTime dateSecond() {
        return DateKit.beginOfSecond(DateKit.now());
    }

    public static DateTime date(java.util.Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return DateKit.dateNew(date);
    }

    public static DateTime date(XMLGregorianCalendar date) {
        if (date == null) {
            return null;
        }
        return DateKit.date(date.toGregorianCalendar());
    }

    public static DateTime dateNew(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return new DateTime(date);
    }

    public static DateTime date(java.util.Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        return new DateTime(date, timeZone);
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return new DateTime(calendar);
    }

    public static DateTime date(TemporalAccessor temporalAccessor) {
        if (temporalAccessor == null) {
            return null;
        }
        return new DateTime(temporalAccessor);
    }

    public static long current() {
        return System.currentTimeMillis();
    }

    public static long currentSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String formatNow() {
        return DateKit.formatDateTime(new DateTime());
    }

    public static String formatToday() {
        return DateKit.formatDate(new DateTime());
    }

    public static int year(java.util.Date date) {
        return DateTime.of(date).year();
    }

    public static int quarter(java.util.Date date) {
        return DateTime.of(date).quarter();
    }

    public static Fields.Quarter quarterEnum(java.util.Date date) {
        return DateTime.of(date).quarterEnum();
    }

    public static int month(java.util.Date date) {
        return DateTime.of(date).month();
    }

    public static Fields.Month monthEnum(java.util.Date date) {
        return DateTime.of(date).monthEnum();
    }

    public static int weekOfYear(java.util.Date date) {
        return DateTime.of(date).weekOfYear();
    }

    public static int weekOfMonth(java.util.Date date) {
        return DateTime.of(date).weekOfMonth();
    }

    public static int dayOfMonth(java.util.Date date) {
        return DateTime.of(date).dayOfMonth();
    }

    public static int dayOfYear(java.util.Date date) {
        return DateTime.of(date).dayOfYear();
    }

    public static int dayOfWeek(java.util.Date date) {
        return DateTime.of(date).dayOfWeek();
    }

    public static Fields.Week dayOfWeekEnum(java.util.Date date) {
        return DateTime.of(date).dayOfWeekEnum();
    }

    public static boolean isWeekend(java.util.Date date) {
        Fields.Week week = DateKit.dayOfWeekEnum(date);
        return Fields.Week.SATURDAY == week || Fields.Week.SUNDAY == week;
    }

    public static int hour(java.util.Date date, boolean is24HourClock) {
        return DateTime.of(date).hour(is24HourClock);
    }

    public static int minute(java.util.Date date) {
        return DateTime.of(date).minute();
    }

    public static int second(java.util.Date date) {
        return DateTime.of(date).second();
    }

    public static int millisecond(java.util.Date date) {
        return DateTime.of(date).millisecond();
    }

    public static boolean isAM(java.util.Date date) {
        return DateTime.of(date).isAM();
    }

    public static boolean isPM(java.util.Date date) {
        return DateTime.of(date).isPM();
    }

    public static int thisYear() {
        return DateKit.year(DateKit.now());
    }

    public static int thisMonth() {
        return DateKit.month(DateKit.now());
    }

    public static Fields.Month thisMonthEnum() {
        return DateKit.monthEnum(DateKit.now());
    }

    public static int thisWeekOfYear() {
        return DateKit.weekOfYear(DateKit.now());
    }

    public static int thisWeekOfMonth() {
        return DateKit.weekOfMonth(DateKit.now());
    }

    public static int thisDayOfMonth() {
        return DateKit.dayOfMonth(DateKit.now());
    }

    public static int thisDayOfWeek() {
        return DateKit.dayOfWeek(DateKit.now());
    }

    public static Fields.Week thisDayOfWeekEnum() {
        return DateKit.dayOfWeekEnum(DateKit.now());
    }

    public static int thisHour(boolean is24HourClock) {
        return DateKit.hour(DateKit.now(), is24HourClock);
    }

    public static int thisMinute() {
        return DateKit.minute(DateKit.now());
    }

    public static int thisSecond() {
        return DateKit.second(DateKit.now());
    }

    public static int thisMillisecond() {
        return DateKit.millisecond(DateKit.now());
    }

    public static String yearAndQuarter(java.util.Date date) {
        return DateKit.yearAndQuarter(DateKit.calendar(date));
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime) {
        return Formatter.formatNormal(localDateTime);
    }

    public static String format(LocalDateTime localDateTime, String format) {
        return Formatter.format((TemporalAccessor)localDateTime, format);
    }

    public static String format(java.util.Date date, String format) {
        if (null == date || StringKit.isBlank(format)) {
            return null;
        }
        if (CustomFormat.isCustomFormat(format)) {
            return CustomFormat.format(date, (CharSequence)format);
        }
        TimeZone timeZone = null;
        if (date instanceof DateTime) {
            timeZone = ((DateTime)date).getTimeZone();
        }
        return DateKit.format(date, DateKit.newSimpleFormat(format, null, timeZone));
    }

    public static String format(java.util.Date date, FormatPrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(java.util.Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(java.util.Date date, DateTimeFormatter format) {
        if (null == format || null == date) {
            return null;
        }
        return Formatter.format((TemporalAccessor)date.toInstant(), format);
    }

    public static String formatDateTime(java.util.Date date) {
        if (null == date) {
            return null;
        }
        return Formatter.NORM_DATETIME_FORMAT.format(date);
    }

    public static String formatDate(java.util.Date date) {
        if (null == date) {
            return null;
        }
        return Formatter.NORM_DATE_FORMAT.format(date);
    }

    public static String formatTime(java.util.Date date) {
        if (null == date) {
            return null;
        }
        return Formatter.NORM_TIME_FORMAT.format(date);
    }

    public static String formatHttpDate(java.util.Date date) {
        if (null == date) {
            return null;
        }
        return Formatter.HTTP_DATETIME_FORMAT_GMT.format(date);
    }

    public static String formatChineseDate(java.util.Date date, boolean isUppercase, boolean withTime) {
        if (null == date) {
            return null;
        }
        if (!isUppercase) {
            return (withTime ? Formatter.CN_DATE_TIME_FORMAT : Formatter.CN_DATE_FORMAT).format(date);
        }
        return Calendars.formatChineseDate(Calendars.calendar(date), withTime);
    }

    public static DateTime parse(CharSequence dateStr, DateFormat dateFormat) {
        return new DateTime(dateStr, dateFormat);
    }

    public static DateTime parse(CharSequence dateStr, PositionDateParser parser) {
        return new DateTime(dateStr, parser);
    }

    public static DateTime parse(CharSequence dateStr, PositionDateParser parser, boolean lenient) {
        return new DateTime(dateStr, parser, lenient);
    }

    public static DateTime parse(CharSequence dateStr, DateTimeFormatter formatter) {
        return new DateTime(dateStr, formatter);
    }

    public static DateTime parse(CharSequence dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime parse(CharSequence dateStr, String format, Locale locale) {
        if (CustomFormat.isCustomFormat(format)) {
            return new DateTime(CustomFormat.parse(dateStr, format));
        }
        return new DateTime(dateStr, DateKit.newSimpleFormat(format, locale, null));
    }

    public static DateTime parse(String text, String ... parsePatterns) throws DateException {
        return DateKit.date(Calendars.parseByPatterns(text, parsePatterns));
    }

    public static DateTime parse(CharSequence dateCharSequence) {
        if (StringKit.isBlank(dateCharSequence)) {
            return null;
        }
        String dateStr = dateCharSequence.toString();
        java.util.Date result = RegisterDateParser.INSTANCE.parse(dateStr = StringKit.removeAll((CharSequence)dateStr.trim(), '\u65e5', '\u79d2'));
        if (null != result) {
            return DateKit.date(result);
        }
        if (NormalDateParser.INSTANCE.test(dateStr = DateKit.normalize(dateStr))) {
            return NormalDateParser.INSTANCE.parse(dateStr);
        }
        throw new DateException("No format fit for date String [{}] !", new Object[]{dateStr});
    }

    public static DateTime truncate(java.util.Date date, Fields.Type type) {
        return new DateTime(DateKit.truncate(DateKit.calendar(date), type));
    }

    public static DateTime round(java.util.Date date, Fields.Type type) {
        return new DateTime(DateKit.round(DateKit.calendar(date), type));
    }

    public static DateTime ceiling(java.util.Date date, Fields.Type type) {
        return new DateTime(DateKit.ceiling(DateKit.calendar(date), type));
    }

    public static DateTime ceiling(java.util.Date date, Fields.Type type, boolean truncateMillisecond) {
        return new DateTime(DateKit.ceiling(DateKit.calendar(date), type, truncateMillisecond));
    }

    public static DateTime beginOfSecond(java.util.Date date) {
        return new DateTime(DateKit.beginOfSecond(DateKit.calendar(date)));
    }

    public static DateTime endOfSecond(java.util.Date date) {
        return new DateTime(DateKit.endOfSecond(DateKit.calendar(date)));
    }

    public static DateTime beginOfHour(java.util.Date date) {
        return new DateTime(DateKit.beginOfHour(DateKit.calendar(date)));
    }

    public static DateTime endOfHour(java.util.Date date) {
        return new DateTime(DateKit.endOfHour(DateKit.calendar(date)));
    }

    public static DateTime beginOfMinute(java.util.Date date) {
        return new DateTime(DateKit.beginOfMinute(DateKit.calendar(date)));
    }

    public static DateTime endOfMinute(java.util.Date date) {
        return new DateTime(DateKit.endOfMinute(DateKit.calendar(date)));
    }

    public static DateTime beginOfDay(java.util.Date date) {
        return new DateTime(DateKit.beginOfDay(DateKit.calendar(date)));
    }

    public static DateTime endOfDay(java.util.Date date) {
        return new DateTime(DateKit.endOfDay(DateKit.calendar(date)));
    }

    public static DateTime beginOfWeek(java.util.Date date) {
        return new DateTime(DateKit.beginOfWeek(DateKit.calendar(date)));
    }

    public static DateTime beginOfWeek(java.util.Date date, boolean isMondayAsFirstDay) {
        return new DateTime(DateKit.beginOfWeek(DateKit.calendar(date), isMondayAsFirstDay));
    }

    public static DateTime endOfWeek(java.util.Date date) {
        return new DateTime(DateKit.endOfWeek(DateKit.calendar(date)));
    }

    public static DateTime endOfWeek(java.util.Date date, boolean isSundayAsLastDay) {
        return new DateTime(DateKit.endOfWeek(DateKit.calendar(date), isSundayAsLastDay));
    }

    public static DateTime beginOfMonth(java.util.Date date) {
        return new DateTime(DateKit.beginOfMonth(DateKit.calendar(date)));
    }

    public static DateTime endOfMonth(java.util.Date date) {
        return new DateTime(DateKit.endOfMonth(DateKit.calendar(date)));
    }

    public static DateTime beginOfQuarter(java.util.Date date) {
        return new DateTime(DateKit.beginOfQuarter(DateKit.calendar(date)));
    }

    public static DateTime endOfQuarter(java.util.Date date) {
        return new DateTime(DateKit.endOfQuarter(DateKit.calendar(date)));
    }

    public static DateTime beginOfYear(java.util.Date date) {
        return new DateTime(DateKit.beginOfYear(DateKit.calendar(date)));
    }

    public static DateTime endOfYear(java.util.Date date) {
        return new DateTime(DateKit.endOfYear(DateKit.calendar(date)));
    }

    public static DateTime yesterday() {
        return DateKit.offsetDay(new DateTime(), -1);
    }

    public static DateTime tomorrow() {
        return DateKit.offsetDay(new DateTime(), 1);
    }

    public static DateTime lastWeek() {
        return DateKit.offsetWeek(new DateTime(), -1);
    }

    public static DateTime nextWeek() {
        return DateKit.offsetWeek(new DateTime(), 1);
    }

    public static DateTime lastMonth() {
        return DateKit.offsetMonth(new DateTime(), -1);
    }

    public static DateTime nextMonth() {
        return DateKit.offsetMonth(new DateTime(), 1);
    }

    public static DateTime offsetMillisecond(java.util.Date date, int offset) {
        return DateKit.offset(date, Fields.Type.MILLISECOND, offset);
    }

    public static DateTime offsetSecond(java.util.Date date, int offset) {
        return DateKit.offset(date, Fields.Type.SECOND, offset);
    }

    public static DateTime offsetMinute(java.util.Date date, int offset) {
        return DateKit.offset(date, Fields.Type.MINUTE, offset);
    }

    public static DateTime offsetHour(java.util.Date date, int offset) {
        return DateKit.offset(date, Fields.Type.HOUR_OF_DAY, offset);
    }

    public static DateTime offsetDay(java.util.Date date, int offset) {
        return DateKit.offset(date, Fields.Type.DAY_OF_YEAR, offset);
    }

    public static DateTime offsetWeek(java.util.Date date, int offset) {
        return DateKit.offset(date, Fields.Type.WEEK_OF_YEAR, offset);
    }

    public static DateTime offsetMonth(java.util.Date date, int offset) {
        return DateKit.offset(date, Fields.Type.MONTH, offset);
    }

    public static DateTime offset(java.util.Date date, Fields.Type type, int offset) {
        return DateKit.dateNew(date).offset(type, offset);
    }

    public static long between(java.util.Date beginDate, java.util.Date endDate, Fields.Units unit) {
        return DateKit.between(beginDate, endDate, unit, true);
    }

    public static long between(java.util.Date beginDate, java.util.Date endDate, Fields.Units unit, boolean isAbs) {
        return new Between(beginDate, endDate, isAbs).between(unit);
    }

    public static long betweenMs(java.util.Date beginDate, java.util.Date endDate) {
        return new Between(beginDate, endDate).between(Fields.Units.MS);
    }

    public static long betweenDay(java.util.Date beginDate, java.util.Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateKit.beginOfDay(beginDate);
            endDate = DateKit.beginOfDay(endDate);
        }
        return DateKit.between(beginDate, endDate, Fields.Units.DAY);
    }

    public static long betweenWeek(java.util.Date beginDate, java.util.Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateKit.beginOfDay(beginDate);
            endDate = DateKit.beginOfDay(endDate);
        }
        return DateKit.between(beginDate, endDate, Fields.Units.WEEK);
    }

    public static long betweenMonth(java.util.Date beginDate, java.util.Date endDate, boolean isReset) {
        return new Between(beginDate, endDate).betweenMonth(isReset);
    }

    public static long betweenYear(java.util.Date beginDate, java.util.Date endDate, boolean isReset) {
        return new Between(beginDate, endDate).betweenYear(isReset);
    }

    public static String formatBetween(java.util.Date beginDate, java.util.Date endDate, FormatPeriod.Level level) {
        return DateKit.formatBetween(DateKit.between(beginDate, endDate, Fields.Units.MS), level);
    }

    public static String formatBetween(java.util.Date beginDate, java.util.Date endDate) {
        return DateKit.formatBetween(DateKit.between(beginDate, endDate, Fields.Units.MS));
    }

    public static String formatBetween(long betweenMs, FormatPeriod.Level level) {
        return FormatPeriod.of(betweenMs, level).format();
    }

    public static String formatBetween(long betweenMs) {
        return FormatPeriod.of(betweenMs, FormatPeriod.Level.MILLISECOND).format();
    }

    public static boolean isIn(java.util.Date date, java.util.Date beginDate, java.util.Date endDate) {
        return DateKit.isIn(date, beginDate, endDate, true, true);
    }

    public static boolean isIn(java.util.Date date, java.util.Date beginDate, java.util.Date endDate, boolean includeBegin, boolean includeEnd) {
        return new DateTime().isIn(date, beginDate, endDate, includeBegin, includeEnd);
    }

    public static boolean isSameTime(java.util.Date date1, java.util.Date date2) {
        return date1.compareTo(date2) == 0;
    }

    public static boolean isSameDay(java.util.Date date1, java.util.Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return Calendars.isSameDay(DateKit.calendar(date1), DateKit.calendar(date2));
    }

    public static boolean isSameWeek(java.util.Date date1, java.util.Date date2, boolean isMon) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return Calendars.isSameWeek(DateKit.calendar(date1), DateKit.calendar(date2), isMon);
    }

    public static boolean isSameMonth(java.util.Date date1, java.util.Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return Calendars.isSameMonth(DateKit.calendar(date1), DateKit.calendar(date2));
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static StopWatch createStopWatch() {
        return new StopWatch();
    }

    public static StopWatch createStopWatch(String id) {
        return new StopWatch(id);
    }

    public static int ageOfNow(String birthDay) {
        return DateKit.ageOfNow(DateKit.parse(birthDay));
    }

    public static int ageOfNow(java.util.Date birthDay) {
        return DateKit.age(birthDay, DateKit.now());
    }

    public static boolean isLeapYear(int year) {
        return Year.isLeap(year);
    }

    public static int age(java.util.Date birthday, java.util.Date dateToCompare) {
        if (null == dateToCompare) {
            dateToCompare = DateKit.now();
        }
        return DateKit.age(birthday.getTime(), dateToCompare.getTime());
    }

    public static int timeToSecond(String timeStr) {
        if (StringKit.isEmpty(timeStr)) {
            return 0;
        }
        List<String> hms = CharsBacker.split(timeStr, ":", 3, true, true);
        int lastIndex = hms.size() - 1;
        int result = 0;
        for (int i = lastIndex; i >= 0; --i) {
            result += (int)((double)Integer.parseInt(hms.get(i)) * Math.pow(60.0, lastIndex - i));
        }
        return result;
    }

    public static String secondToTime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Seconds must be a positive number!");
        }
        int hour = seconds / 3600;
        int other = seconds % 3600;
        int minute = other / 60;
        int second = other % 60;
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(":");
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        return sb.toString();
    }

    public static Boundary range(java.util.Date start, java.util.Date end, Fields.Type unit) {
        return new Boundary(start, end, unit);
    }

    public static List<DateTime> rangeContains(Boundary start, Boundary end) {
        ArrayList<DateTime> startDateTimes = ListKit.of(start);
        ArrayList<DateTime> endDateTimes = ListKit.of(end);
        return startDateTimes.stream().filter(endDateTimes::contains).collect(Collectors.toList());
    }

    public static List<DateTime> rangeNotContains(Boundary start, Boundary end) {
        ArrayList<DateTime> startDateTimes = ListKit.of(start);
        ArrayList<DateTime> endDateTimes = ListKit.of(end);
        return endDateTimes.stream().filter(item -> !startDateTimes.contains(item)).collect(Collectors.toList());
    }

    public static <T> List<T> rangeFunc(java.util.Date start, java.util.Date end, Fields.Type unit, Function<java.util.Date, T> func) {
        if (start == null || end == null || start.after(end)) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (DateTime date : DateKit.range(start, end, unit)) {
            list.add(func.apply(date));
        }
        return list;
    }

    public static void rangeConsume(java.util.Date start, java.util.Date end, Fields.Type unit, Consumer<java.util.Date> consumer) {
        if (start == null || end == null || start.after(end)) {
            return;
        }
        DateKit.range(start, end, unit).forEach(consumer);
    }

    public static List<DateTime> rangeToList(java.util.Date start, java.util.Date end, Fields.Type unit) {
        return ListKit.of(DateKit.range(start, end, unit));
    }

    public static List<DateTime> rangeToList(java.util.Date start, java.util.Date end, Fields.Type unit, int step) {
        return ListKit.of(new Boundary(start, end, unit, step));
    }

    public static String getZodiac(int month, int day) {
        return Zodiac.getZodiac(month, day);
    }

    public static String getChineseZodiac(int year) {
        return Zodiac.getChineseZodiac(year);
    }

    public static int compare(java.util.Date date1, java.util.Date date2) {
        return CompareKit.compare(date1, date2);
    }

    public static int compare(java.util.Date date1, java.util.Date date2, String format) {
        if (format != null) {
            if (date1 != null) {
                date1 = DateKit.parse((CharSequence)DateKit.format(date1, format), format);
            }
            if (date2 != null) {
                date2 = DateKit.parse((CharSequence)DateKit.format(date2, format), format);
            }
        }
        return CompareKit.compare(date1, date2);
    }

    public static long nanosToMillis(long duration) {
        return TimeUnit.NANOSECONDS.toMillis(duration);
    }

    public static double nanosToSeconds(long duration) {
        return (double)duration / 1.0E9;
    }

    public static Instant toInstant(java.util.Date date) {
        return null == date ? null : date.toInstant();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        return Almanac.toInstant(temporalAccessor);
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return Resolver.of(instant);
    }

    public static LocalDateTime toLocalDateTime(java.util.Date date) {
        return Resolver.of(date);
    }

    public static int lengthOfYear(int year) {
        return Year.of(year).length();
    }

    public static int lengthOfMonth(int month, boolean isLeapYear) {
        return Month.of(month).length(isLeapYear);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern) {
        return DateKit.newSimpleFormat(pattern, null, null);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern, Locale locale, TimeZone timeZone) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        if (null != timeZone) {
            format.setTimeZone(timeZone);
        }
        format.setLenient(false);
        return format;
    }

    public static String getShortName(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
        }
        return unit.name().toLowerCase();
    }

    public static boolean isOverlap(java.util.Date realStartTime, java.util.Date realEndTime, java.util.Date startTime, java.util.Date endTime) {
        return realStartTime.compareTo(endTime) <= 0 && startTime.compareTo(realEndTime) <= 0;
    }

    public static boolean isLastDayOfMonth(java.util.Date date) {
        return DateKit.date(date).isLastDayOfMonth();
    }

    public static int getLastDayOfMonth(java.util.Date date) {
        return DateKit.date(date).getLastDayOfMonth();
    }

    private static String normalize(CharSequence dateStr) {
        if (StringKit.isBlank(dateStr)) {
            return StringKit.toString(dateStr);
        }
        List<String> dateAndTime = CharsBacker.splitTrim(dateStr, " ");
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return StringKit.toString(dateStr);
        }
        StringBuilder builder = StringKit.builder();
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = StringKit.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = StringKit.removeSuffix(timePart, ":");
            timePart = timePart.replace(',', '.');
            builder.append(timePart);
        }
        return builder.toString();
    }

    public boolean isIn(java.util.Date beginDate, java.util.Date endDate) {
        return new DateTime().isIn(beginDate, endDate);
    }

    public static class SQL {
        public static Timestamp timestamp(java.util.Date date) {
            Assert.notNull(date);
            return new Timestamp(date.getTime());
        }

        public static Date date(java.util.Date date) {
            Assert.notNull(date);
            return new Date(date.getTime());
        }

        public static Time time(java.util.Date date) {
            Assert.notNull(date);
            return new Time(date.getTime());
        }

        public static <T extends java.util.Date> T wrap(Class<?> targetClass, long mills) {
            if (java.util.Date.class == targetClass) {
                return (T)new java.util.Date(mills);
            }
            if (DateTime.class == targetClass) {
                return (T)DateKit.date(mills);
            }
            if (Date.class == targetClass) {
                return (T)new Date(mills);
            }
            if (Time.class == targetClass) {
                return (T)new Time(mills);
            }
            if (Timestamp.class == targetClass) {
                return (T)new Timestamp(mills);
            }
            throw new UnsupportedOperationException(StringKit.format("Unsupported target Date type: {}", targetClass.getName()));
        }
    }
}

