/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.miaixz.bus.core.center.function.ConsumerX;
import org.miaixz.bus.core.center.function.FunctionX;
import org.miaixz.bus.core.io.BomReader;
import org.miaixz.bus.core.io.file.FileMode;
import org.miaixz.bus.core.io.file.FileName;
import org.miaixz.bus.core.io.file.FileReader;
import org.miaixz.bus.core.io.file.FileTailer;
import org.miaixz.bus.core.io.file.FileType;
import org.miaixz.bus.core.io.file.FileWriter;
import org.miaixz.bus.core.io.file.LineSeparator;
import org.miaixz.bus.core.io.file.PathResolve;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.io.stream.BOMInputStream;
import org.miaixz.bus.core.io.unit.DataSize;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Console;
import org.miaixz.bus.core.lang.Keys;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.ResourceKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.ThreadKit;
import org.miaixz.bus.core.xyz.UrlKit;
import org.miaixz.bus.core.xyz.ZipKit;

public class FileKit
extends PathResolve {
    private static final Pattern PATTERN_PATH_ABSOLUTE = Pattern.compile("^[a-zA-Z]:([/\\\\].*)?");

    public static boolean isWindows() {
        return '\\' == File.separatorChar;
    }

    public static File[] ls(String path) {
        if (path == null) {
            return null;
        }
        File file = FileKit.file(path);
        if (file.isDirectory()) {
            return file.listFiles();
        }
        throw new InternalException(StringKit.format("Path [{}] is not directory!", path));
    }

    public static boolean isEmpty(File file) {
        if (null == file || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            String[] subFiles = file.list();
            return ArrayKit.isEmpty(subFiles);
        }
        if (file.isFile()) {
            return file.length() <= 0L;
        }
        return false;
    }

    public static boolean isNotEmpty(File file) {
        return !FileKit.isEmpty(file);
    }

    public static boolean isDirEmpty(File dir) {
        return FileKit.isDirEmpty(dir.toPath());
    }

    public static List<File> loopFiles(String path, FileFilter fileFilter) {
        return FileKit.loopFiles(FileKit.file(path), fileFilter);
    }

    public static List<File> loopFiles(File file, FileFilter fileFilter) {
        return FileKit.loopFiles(file, -1, fileFilter);
    }

    public static List<File> loopFiles(File file, int maxDepth, FileFilter fileFilter) {
        return FileKit.loopFiles(file.toPath(), maxDepth, fileFilter);
    }

    public static List<File> loopFiles(String path) {
        return FileKit.loopFiles(FileKit.file(path));
    }

    public static List<File> loopFiles(File file) {
        return FileKit.loopFiles(file, null);
    }

    public static void walkFiles(File file, Predicate<File> predicate) {
        File[] subFiles;
        if (predicate.test(file) && file.isDirectory() && ArrayKit.isNotEmpty(subFiles = file.listFiles())) {
            for (File tmp : subFiles) {
                FileKit.walkFiles(tmp, predicate);
            }
        }
    }

    public static List<String> listFileNames(String path) throws InternalException {
        List<String> files2;
        if (path == null) {
            return new ArrayList<String>(0);
        }
        int index = path.lastIndexOf(".jar!");
        if (index < 0) {
            File[] files2;
            ArrayList<String> paths = new ArrayList<String>();
            for (File file : files2 = FileKit.ls(path)) {
                if (!file.isFile()) continue;
                paths.add(file.getName());
            }
            return paths;
        }
        path = FileKit.getAbsolutePath(path);
        index += ".jar".length();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(path.substring(0, index));
            files2 = ZipKit.listFileNames(jarFile, StringKit.removePrefix(path.substring(index + 1), "/"));
        }
        catch (IOException e) {
            try {
                throw new InternalException(StringKit.format("Can not read file path of [{}]", path), e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly(jarFile);
                throw throwable;
            }
        }
        IoKit.closeQuietly(jarFile);
        return files2;
    }

    public static File newFile(String path) {
        return new File(path);
    }

    public static File file(String path) {
        if (null == path) {
            return null;
        }
        return new File(FileKit.getAbsolutePath(path));
    }

    public static File file(String parent, String path) {
        return FileKit.file(new File(parent), path);
    }

    public static File file(File parent, String path) {
        if (StringKit.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return FileKit.checkSlip(parent, FileKit.buildFile(parent, path));
    }

    public static File file(File directory, String ... names) {
        Assert.notNull(directory, "directory must not be null", new Object[0]);
        if (ArrayKit.isEmpty(names)) {
            return directory;
        }
        File file = directory;
        for (String name : names) {
            if (null == name) continue;
            file = FileKit.file(file, name);
        }
        return file;
    }

    public static File file(String ... names) {
        if (ArrayKit.isEmpty(names)) {
            return null;
        }
        File file = null;
        for (String name : names) {
            file = file == null ? FileKit.file(name) : FileKit.file(file, name);
        }
        return file;
    }

    public static File file(URI uri) {
        if (uri == null) {
            throw new NullPointerException("File uri is null!");
        }
        return new File(uri);
    }

    public static File file(URL url) {
        return new File(UrlKit.toURI(url));
    }

    public static File getTmpDir() {
        return FileKit.file(Keys.getTmpDirPath());
    }

    public static File getUserHomeDir() {
        return FileKit.file(Keys.getUserHomePath());
    }

    public static boolean exists(String path) {
        return null != path && FileKit.file(path).exists();
    }

    public static boolean exists(File file) {
        return null != file && file.exists();
    }

    public static boolean exists(String directory, String regexp) {
        File file = new File(directory);
        if (!file.exists()) {
            return false;
        }
        String[] fileList = file.list();
        if (fileList == null) {
            return false;
        }
        for (String fileName : fileList) {
            if (!fileName.matches(regexp)) continue;
            return true;
        }
        return false;
    }

    public static Date lastModifiedTime(File file) {
        if (!FileKit.exists(file)) {
            return null;
        }
        return new Date(file.lastModified());
    }

    public static Date lastModifiedTime(String path) {
        return FileKit.lastModifiedTime(new File(path));
    }

    public static long size(File file) {
        return FileKit.size(file, false);
    }

    public static long size(File file, boolean includeDirSize) {
        if (null == file || !file.exists() || FileKit.isSymlink(file)) {
            return 0L;
        }
        if (file.isDirectory()) {
            long size = includeDirSize ? file.length() : 0L;
            File[] subFiles = file.listFiles();
            if (ArrayKit.isEmpty(subFiles)) {
                return 0L;
            }
            for (File subFile : subFiles) {
                size += FileKit.size(subFile, includeDirSize);
            }
            return size;
        }
        return file.length();
    }

    public static int getTotalLines(File file) {
        return FileKit.getTotalLines(file, 1024);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getTotalLines(File file, int bufferSize) {
        if (!FileKit.isFile(file)) {
            throw new InternalException("Input must be a File");
        }
        if (bufferSize < 1) {
            bufferSize = 1024;
        }
        try (BufferedInputStream is = FileKit.getInputStream(file);){
            int i;
            byte[] c = new byte[bufferSize];
            int readChars = ((InputStream)is).read(c);
            if (readChars == -1) {
                int n2 = 0;
                return n2;
            }
            int count = 1;
            while (readChars == bufferSize) {
                for (i = 0; i < bufferSize; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
                readChars = ((InputStream)is).read(c);
            }
            while (readChars != -1) {
                for (i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
                readChars = ((InputStream)is).read(c);
            }
            int n = count;
            return n;
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static boolean newerThan(File file, File reference) {
        if (null == reference || !reference.exists()) {
            return true;
        }
        return FileKit.newerThan(file, reference.lastModified());
    }

    public static boolean newerThan(File file, long timeMillis) {
        if (null == file || !file.exists()) {
            return false;
        }
        return file.lastModified() > timeMillis;
    }

    public static File touch(String path) throws InternalException {
        if (path == null) {
            return null;
        }
        return FileKit.touch(FileKit.file(path));
    }

    public static File touch(File file) throws InternalException {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            FileKit.mkParentDirs(file);
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                throw new InternalException(e);
            }
        }
        return file;
    }

    public static File touch(File parent, String path) throws InternalException {
        return FileKit.touch(FileKit.file(parent, path));
    }

    public static File touch(String parent, String path) throws InternalException {
        return FileKit.touch(FileKit.file(parent, path));
    }

    public static File mkParentDirs(File file) {
        if (null == file) {
            return null;
        }
        return FileKit.mkdir(FileKit.getParent(file, 1));
    }

    public static File mkParentDirs(String path) {
        if (path == null) {
            return null;
        }
        return FileKit.mkParentDirs(FileKit.file(path));
    }

    public static void del(String fullFileOrDirPath) throws InternalException {
        FileKit.del(FileKit.file(fullFileOrDirPath));
    }

    public static void del(File file) throws InternalException {
        Assert.notNull(file, "File must be not null!", new Object[0]);
        FileKit.del(file.toPath());
    }

    public static void clean(String dirPath) throws InternalException {
        FileKit.clean(FileKit.file(dirPath));
    }

    public static void clean(File directory) throws InternalException {
        Assert.notNull(directory, "File must be not null!", new Object[0]);
        FileKit.clean(directory.toPath());
    }

    public static File mkdir(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        File dir = FileKit.file(dirPath);
        return FileKit.mkdir(dir);
    }

    public static File mkdir(File dir) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists()) {
            FileKit.mkdirsSafely(dir, 5, 1L);
        }
        return dir;
    }

    public static boolean mkdirsSafely(File dir, int tryCount, long sleepMillis) {
        if (dir == null) {
            return false;
        }
        if (dir.isDirectory()) {
            return true;
        }
        for (int i = 1; i <= tryCount; ++i) {
            dir.mkdirs();
            if (dir.exists()) {
                return true;
            }
            ThreadKit.sleep(sleepMillis);
        }
        return dir.exists();
    }

    public static File createTempFile(File dir) throws InternalException {
        return FileKit.createTempFile("x", null, dir, true);
    }

    public static File createTempFile() throws InternalException {
        return FileKit.createTempFile("x", null, null, true);
    }

    public static File createTempFile(String suffix, boolean isReCreat) throws InternalException {
        return FileKit.createTempFile("x", suffix, null, isReCreat);
    }

    public static File createTempFile(String prefix, String suffix, boolean isReCreat) throws InternalException {
        return FileKit.createTempFile(prefix, suffix, null, isReCreat);
    }

    public static File createTempFile(File dir, boolean isReCreat) throws InternalException {
        return FileKit.createTempFile("x", null, dir, isReCreat);
    }

    public static File createTempFile(String prefix, String suffix, File dir, boolean isReCreat) throws InternalException {
        try {
            File file = PathResolve.createTempFile(prefix, suffix, null == dir ? null : dir.toPath()).toFile().getCanonicalFile();
            if (isReCreat) {
                file.delete();
                file.createNewFile();
            }
            return file;
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static File copy(Resource src, File target, boolean isOverride) throws InternalException {
        CopyOption[] copyOptionArray;
        Assert.notNull(src, "Src file must be not null!", new Object[0]);
        Assert.notNull(target, "target file must be not null!", new Object[0]);
        Path path = target.toPath();
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        return FileKit.copy(src, path, copyOptionArray).toFile();
    }

    public static File copy(InputStream src, File target, StandardCopyOption ... options) throws InternalException {
        Assert.notNull(src, "Source File is null !", new Object[0]);
        Assert.notNull(target, "Target File or directory is null !", new Object[0]);
        return FileKit.copy(src, target.toPath(), (CopyOption[])options).toFile();
    }

    public static long copy(File src, OutputStream out) throws InternalException {
        Assert.notNull(src, "Source File is null !", new Object[0]);
        Assert.notNull(out, "Target stream is null !", new Object[0]);
        return FileKit.copy(src.toPath(), out);
    }

    public static File copy(String srcPath, String targetPath, boolean isOverride) throws InternalException {
        return FileKit.copy(FileKit.file(srcPath), FileKit.file(targetPath), isOverride);
    }

    public static File copy(File src, File target, boolean isOverride) throws InternalException {
        CopyOption[] copyOptionArray;
        Assert.notNull(src, "Src file must be not null!", new Object[0]);
        Assert.notNull(target, "target file must be not null!", new Object[0]);
        Path path = src.toPath();
        Path path2 = target.toPath();
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        return FileKit.copy(path, path2, copyOptionArray).toFile();
    }

    public static File copyContent(File src, File target, boolean isOverride) throws InternalException {
        CopyOption[] copyOptionArray;
        Assert.notNull(src, "Src file must be not null!", new Object[0]);
        Assert.notNull(target, "target file must be not null!", new Object[0]);
        Path path = src.toPath();
        Path path2 = target.toPath();
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        return FileKit.copyContent(path, path2, copyOptionArray).toFile();
    }

    public static File move(File src, File target, boolean isOverride) throws InternalException {
        Assert.notNull(src, "Src file must be not null!", new Object[0]);
        Assert.notNull(target, "target file must be not null!", new Object[0]);
        return FileKit.move(src.toPath(), target.toPath(), isOverride).toFile();
    }

    public static File rename(File file, String newName, boolean isOverride) {
        return FileKit.rename(file, newName, false, isOverride);
    }

    public static File rename(File file, String newName, boolean isRetainExt, boolean isOverride) {
        String extName;
        if (isRetainExt && StringKit.isNotBlank(extName = FileName.extName(file))) {
            newName = newName.concat(".").concat(extName);
        }
        return FileKit.rename(file.toPath(), newName, isOverride).toFile();
    }

    public static String getCanonicalPath(File file) {
        if (null == file) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static String getAbsolutePath(String path, Class<?> baseClass) {
        String normalPath;
        if (path == null) {
            normalPath = "";
        } else {
            normalPath = FileName.normalize(path);
            if (FileKit.isAbsolutePath(normalPath)) {
                return normalPath;
            }
        }
        URL url = ResourceKit.getResourceUrl(normalPath, baseClass);
        if (null != url) {
            return FileName.normalize(UrlKit.getDecodedPath(url));
        }
        String classPath = ClassKit.getClassPath();
        if (null == classPath) {
            return path;
        }
        return FileName.normalize(classPath.concat(Objects.requireNonNull(path)));
    }

    public static String getAbsolutePath(String path) {
        return FileKit.getAbsolutePath(path, null);
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static boolean isAbsolutePath(String path) {
        if (StringKit.isEmpty(path)) {
            return false;
        }
        return '/' == path.charAt(0) || PatternKit.isMatch(PATTERN_PATH_ABSOLUTE, (CharSequence)path);
    }

    public static boolean isDirectory(String path) {
        return null != path && FileKit.file(path).isDirectory();
    }

    public static boolean isDirectory(File file) {
        return null != file && file.isDirectory();
    }

    public static boolean isFile(String path) {
        return null != path && FileKit.file(path).isFile();
    }

    public static boolean isFile(File file) {
        return null != file && file.isFile();
    }

    public static boolean equals(File file1, File file2) throws InternalException {
        Assert.notNull(file1);
        Assert.notNull(file2);
        if (!file1.exists() || !file2.exists()) {
            return !file1.exists() && !file2.exists() && FileKit.pathEquals(file1, file2);
        }
        return FileKit.equals(file1.toPath(), file2.toPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(File file1, File file2) throws InternalException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new InternalException("Can't compare directories, only files");
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        if (FileKit.equals(file1, file2)) {
            return true;
        }
        BufferedInputStream input1 = null;
        BufferedInputStream input2 = null;
        try {
            input1 = FileKit.getInputStream(file1);
            input2 = FileKit.getInputStream(file2);
            bl = IoKit.contentEquals(input1, input2);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(input1);
            IoKit.closeQuietly(input2);
            throw throwable;
        }
        IoKit.closeQuietly(input1);
        IoKit.closeQuietly(input2);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEqualsIgnoreEOL(File file1, File file2, Charset charset) throws InternalException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new InternalException("Can't compare directories, only files");
        }
        if (FileKit.equals(file1, file2)) {
            return true;
        }
        BufferedReader input1 = null;
        BufferedReader input2 = null;
        try {
            input1 = FileKit.getReader(file1, charset);
            input2 = FileKit.getReader(file2, charset);
            bl = IoKit.contentEqualsIgnoreEOL(input1, input2);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(input1);
            IoKit.closeQuietly(input2);
            throw throwable;
        }
        IoKit.closeQuietly(input1);
        IoKit.closeQuietly(input2);
        return bl;
    }

    public static boolean pathEquals(File file1, File file2) {
        block8: {
            if (FileKit.isWindows()) {
                try {
                    if (StringKit.equalsIgnoreCase(file1.getCanonicalPath(), file2.getCanonicalPath())) {
                        return true;
                    }
                    break block8;
                }
                catch (Exception e) {
                    if (StringKit.equalsIgnoreCase(file1.getAbsolutePath(), file2.getAbsolutePath())) {
                        return true;
                    }
                    break block8;
                }
            }
            try {
                if (StringKit.equals(file1.getCanonicalPath(), file2.getCanonicalPath())) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!StringKit.equals(file1.getAbsolutePath(), file2.getAbsolutePath())) break block8;
                return true;
            }
        }
        return false;
    }

    public static int lastIndexOfSeparator(String filePath) {
        if (StringKit.isNotEmpty(filePath)) {
            int i = filePath.length();
            while (--i >= 0) {
                char c = filePath.charAt(i);
                if (!CharKit.isFileSeparator(c)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isModified(File file, long lastModifyTime) {
        if (null == file || !file.exists()) {
            return true;
        }
        return file.lastModified() != lastModifyTime;
    }

    public static String normalize(String path) {
        return FileName.normalize(path);
    }

    public static String subPath(String rootDir, File file) {
        try {
            return FileKit.subPath(rootDir, file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static String subPath(String dirPath, String filePath) {
        if (StringKit.isNotEmpty(dirPath) && StringKit.isNotEmpty(filePath)) {
            dirPath = StringKit.removeSuffix(FileName.normalize(dirPath), "/");
            filePath = FileName.normalize(filePath);
            String result = StringKit.removePrefixIgnoreCase(filePath, dirPath);
            return StringKit.removePrefix(result, "/");
        }
        return filePath;
    }

    public static boolean pathEndsWith(File file, String suffix) {
        return file.getPath().toLowerCase().endsWith(suffix);
    }

    public static String getType(File file) throws InternalException {
        return FileType.getType(file);
    }

    public static BufferedInputStream getInputStream(File file) throws InternalException {
        return IoKit.toBuffered(IoKit.toStream(file));
    }

    public static BufferedInputStream getInputStream(String path) throws InternalException {
        return FileKit.getInputStream(FileKit.file(path));
    }

    public static BOMInputStream getBOMInputStream(File file) throws InternalException {
        try {
            return new BOMInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static BomReader getBOMReader(File file) {
        return IoKit.toBomReader(FileKit.getBOMInputStream(file));
    }

    public static BufferedReader getUtf8Reader(File file) throws InternalException {
        return FileKit.getReader(file, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static BufferedReader getUtf8Reader(String path) throws InternalException {
        return FileKit.getReader(path, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static BufferedReader getReader(File file, Charset charset) throws InternalException {
        return IoKit.toReader(FileKit.getInputStream(file), charset);
    }

    public static BufferedReader getReader(String path, Charset charset) throws InternalException {
        return FileKit.getReader(FileKit.file(path), charset);
    }

    public static byte[] readBytes(File file) throws InternalException {
        if (null == file) {
            return null;
        }
        return FileKit.readBytes(file.toPath());
    }

    public static byte[] readBytes(String filePath) throws InternalException {
        return FileKit.readBytes(FileKit.file(filePath));
    }

    public static String readUtf8String(File file) throws InternalException {
        return FileKit.readString(file, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String readUtf8String(String path) throws InternalException {
        return FileKit.readString(path, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String readString(File file, Charset charset) throws InternalException {
        return FileReader.of(file, charset).readString();
    }

    public static String readString(String path, Charset charset) throws InternalException {
        return FileKit.readString(FileKit.file(path), charset);
    }

    public static String readString(URL url, Charset charset) throws InternalException {
        String string;
        Assert.notNull(url, "Empty url provided!", new Object[0]);
        InputStream in = null;
        try {
            in = url.openStream();
            string = IoKit.read(in, charset);
        }
        catch (IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly(in);
                throw throwable;
            }
        }
        IoKit.closeQuietly(in);
        return string;
    }

    public static <T extends Collection<String>> T readUtf8Lines(String path, T collection) throws InternalException {
        return FileKit.readLines(path, org.miaixz.bus.core.lang.Charset.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(String path, Charset charset, T collection) throws InternalException {
        return FileKit.readLines(FileKit.file(path), charset, collection);
    }

    public static <T extends Collection<String>> T readUtf8Lines(File file, T collection) throws InternalException {
        return FileKit.readLines(file, org.miaixz.bus.core.lang.Charset.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(File file, Charset charset, T collection) throws InternalException {
        return FileReader.of(file, charset).readLines(collection);
    }

    public static <T extends Collection<String>> T readUtf8Lines(URL url, T collection) throws InternalException {
        return FileKit.readLines(url, org.miaixz.bus.core.lang.Charset.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(URL url, Charset charset, T collection) throws InternalException {
        T t;
        InputStream in = null;
        try {
            in = url.openStream();
            t = IoKit.readLines(in, charset, collection);
        }
        catch (IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly(in);
                throw throwable;
            }
        }
        IoKit.closeQuietly(in);
        return t;
    }

    public static List<String> readUtf8Lines(URL url) throws InternalException {
        return FileKit.readLines(url, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static List<String> readLines(URL url, Charset charset) throws InternalException {
        return FileKit.readLines(url, charset, new ArrayList());
    }

    public static List<String> readUtf8Lines(String path) throws InternalException {
        return FileKit.readLines(path, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static List<String> readLines(String path, Charset charset) throws InternalException {
        return FileKit.readLines(path, charset, new ArrayList());
    }

    public static List<String> readUtf8Lines(File file) throws InternalException {
        return FileKit.readLines(file, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static List<String> readLines(File file, Charset charset) throws InternalException {
        return FileKit.readLines(file, charset, new ArrayList());
    }

    public static void readUtf8Lines(File file, ConsumerX<String> lineHandler) throws InternalException {
        FileKit.readLines(file, org.miaixz.bus.core.lang.Charset.UTF_8, lineHandler);
    }

    public static void readLines(File file, Charset charset, ConsumerX<String> lineHandler) throws InternalException {
        FileReader.of(file, charset).readLines(lineHandler);
    }

    public static void readLines(RandomAccessFile file, Charset charset, ConsumerX<String> lineHandler) {
        try {
            String line;
            while ((line = file.readLine()) != null) {
                lineHandler.accept(org.miaixz.bus.core.lang.Charset.convert(line, org.miaixz.bus.core.lang.Charset.ISO_8859_1, charset));
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static void readLine(RandomAccessFile file, Charset charset, ConsumerX<String> lineHandler) {
        String line = FileKit.readLine(file, charset);
        if (null != line) {
            lineHandler.accept(line);
        }
    }

    public static String readLine(RandomAccessFile file, Charset charset) {
        String line;
        try {
            line = file.readLine();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        if (null != line) {
            return org.miaixz.bus.core.lang.Charset.convert(line, org.miaixz.bus.core.lang.Charset.ISO_8859_1, charset);
        }
        return null;
    }

    public static <T> T readUtf8(String path, FunctionX<BufferedReader, T> readerHandler) throws InternalException {
        return FileKit.read(path, org.miaixz.bus.core.lang.Charset.UTF_8, readerHandler);
    }

    public static <T> T read(String path, Charset charset, FunctionX<BufferedReader, T> readerHandler) throws InternalException {
        return FileKit.read(FileKit.file(path), charset, readerHandler);
    }

    public static <T> T readUtf8(File file, FunctionX<BufferedReader, T> readerHandler) throws InternalException {
        return FileKit.read(file, org.miaixz.bus.core.lang.Charset.UTF_8, readerHandler);
    }

    public static <T> T read(File file, Charset charset, FunctionX<BufferedReader, T> readerHandler) throws InternalException {
        return FileReader.of(file, charset).read(readerHandler);
    }

    public static BufferedOutputStream getOutputStream(File file) throws InternalException {
        OutputStream out;
        try {
            out = Files.newOutputStream(FileKit.touch(file).toPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return IoKit.toBuffered(out);
    }

    public static BufferedOutputStream getOutputStream(String path) throws InternalException {
        return FileKit.getOutputStream(FileKit.touch(path));
    }

    public static BufferedWriter getWriter(String path, Charset charset, boolean isAppend) throws InternalException {
        return FileKit.getWriter(FileKit.touch(path), charset, isAppend);
    }

    public static BufferedWriter getWriter(File file, Charset charset, boolean isAppend) throws InternalException {
        return FileWriter.of(file, charset).getWriter(isAppend);
    }

    public static PrintWriter getPrintWriter(String path, Charset charset, boolean isAppend) throws InternalException {
        return new PrintWriter(FileKit.getWriter(path, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(File file, Charset charset, boolean isAppend) throws InternalException {
        return new PrintWriter(FileKit.getWriter(file, charset, isAppend));
    }

    public static String getLineSeparator() {
        return System.lineSeparator();
    }

    public static File writeUtf8String(String content, String path) throws InternalException {
        return FileKit.writeString(content, path, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static File writeUtf8String(String content, File file) throws InternalException {
        return FileKit.writeString(content, file, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static File writeString(String content, String path, Charset charset) throws InternalException {
        return FileKit.writeString(content, FileKit.touch(path), charset);
    }

    public static File writeString(String content, File file, Charset charset) throws InternalException {
        return FileWriter.of(file, charset).write(content);
    }

    public static File appendUtf8String(String content, String path) throws InternalException {
        return FileKit.appendString(content, path, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static File appendString(String content, String path, Charset charset) throws InternalException {
        return FileKit.appendString(content, FileKit.touch(path), charset);
    }

    public static File appendUtf8String(String content, File file) throws InternalException {
        return FileKit.appendString(content, file, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static File appendString(String content, File file, Charset charset) throws InternalException {
        return FileWriter.of(file, charset).append(content);
    }

    public static <T> File writeUtf8Lines(Collection<T> list, String path) throws InternalException {
        return FileKit.writeLines(list, path, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static <T> File writeUtf8Lines(Collection<T> list, File file) throws InternalException {
        return FileKit.writeLines(list, file, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static <T> File writeLines(Collection<T> list, String path, Charset charset) throws InternalException {
        return FileKit.writeLines(list, path, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, File file, Charset charset) throws InternalException {
        return FileKit.writeLines(list, file, charset, false);
    }

    public static <T> File appendUtf8Lines(Collection<T> list, File file) throws InternalException {
        return FileKit.appendLines(list, file, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static <T> File appendUtf8Lines(Collection<T> list, String path) throws InternalException {
        return FileKit.appendLines(list, path, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static <T> File appendLines(Collection<T> list, String path, Charset charset) throws InternalException {
        return FileKit.writeLines(list, path, charset, true);
    }

    public static <T> File appendLines(Collection<T> list, File file, Charset charset) throws InternalException {
        return FileKit.writeLines(list, file, charset, true);
    }

    public static <T> File writeLines(Collection<T> list, String path, Charset charset, boolean isAppend) throws InternalException {
        return FileKit.writeLines(list, FileKit.file(path), charset, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, File file, Charset charset, boolean isAppend) throws InternalException {
        return FileWriter.of(file, charset).writeLines(list, isAppend);
    }

    public static File writeUtf8Map(Map<?, ?> map, File file, String kvSeparator, boolean isAppend) throws InternalException {
        return FileWriter.of(file, org.miaixz.bus.core.lang.Charset.UTF_8).writeMap(map, kvSeparator, isAppend);
    }

    public static File writeMap(Map<?, ?> map, File file, Charset charset, String kvSeparator, boolean isAppend) throws InternalException {
        return FileWriter.of(file, charset).writeMap(map, kvSeparator, isAppend);
    }

    public static File writeBytes(byte[] data, String path) throws InternalException {
        return FileKit.writeBytes(data, FileKit.touch(path));
    }

    public static File writeBytes(byte[] data, File dest) throws InternalException {
        return FileKit.writeBytes(data, dest, 0, data.length, false);
    }

    public static File writeBytes(byte[] data, File dest, int off, int len, boolean isAppend) throws InternalException {
        return FileWriter.of(dest).write(data, off, len, isAppend);
    }

    public static String readableFileSize(File file) {
        Assert.notNull(file);
        return FileKit.readableFileSize(file.length());
    }

    public static String readableFileSize(long size) {
        return DataSize.format(size);
    }

    public static File convertCharset(File file, Charset srcCharset, Charset destCharset) {
        return org.miaixz.bus.core.lang.Charset.convert(file, srcCharset, destCharset);
    }

    public static File convertLineSeparator(File file, Charset charset, LineSeparator lineSeparator) {
        List<String> lines = FileKit.readLines(file, charset);
        return FileWriter.of(file, charset).writeLines(lines, lineSeparator, false);
    }

    public static File getWebRoot() {
        String classPath = ClassKit.getClassPath();
        Console.log(classPath);
        if (StringKit.isNotBlank(classPath)) {
            return FileKit.getParent(FileKit.file(classPath), 2);
        }
        return null;
    }

    public static File getParent(File file) {
        return FileKit.getParent(file, 1);
    }

    public static String getParent(String filePath, int level) {
        File parent = FileKit.getParent(FileKit.file(filePath), level);
        try {
            return null == parent ? null : parent.getCanonicalPath();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static File getParent(File file, int level) {
        File parentFile;
        if (level < 1 || null == file) {
            return file;
        }
        try {
            parentFile = file.getCanonicalFile().getParentFile();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        if (1 == level) {
            return parentFile;
        }
        return FileKit.getParent(parentFile, level - 1);
    }

    public static File checkSlip(File parentFile, File file) throws IllegalArgumentException {
        if (null != parentFile && null != file && !FileKit.isSub(parentFile, file)) {
            throw new IllegalArgumentException(StringKit.format("New file [{}] is outside of the parent dir: [{}]", file, parentFile));
        }
        return file;
    }

    public static String getMimeType(String filePath, String defaultValue) {
        return ObjectKit.defaultIfNull(FileKit.getMimeType(filePath), defaultValue);
    }

    public static String getMimeType(String filePath) {
        if (StringKit.isBlank(filePath)) {
            return null;
        }
        if (StringKit.endWithIgnoreCase(filePath, ".css")) {
            return "text/css";
        }
        if (StringKit.endWithIgnoreCase(filePath, ".js")) {
            return "application/x-javascript";
        }
        if (StringKit.endWithIgnoreCase(filePath, ".rar")) {
            return "application/x-rar-compressed";
        }
        if (StringKit.endWithIgnoreCase(filePath, ".7z")) {
            return "application/x-7z-compressed";
        }
        if (StringKit.endWithIgnoreCase(filePath, ".wgt")) {
            return "application/widget";
        }
        if (StringKit.endWithIgnoreCase(filePath, ".webp")) {
            return "image/webp";
        }
        String contentType = URLConnection.getFileNameMap().getContentTypeFor(filePath);
        if (null == contentType) {
            contentType = FileKit.getMimeType(Paths.get(filePath, new String[0]));
        }
        return contentType;
    }

    public static boolean isSymlink(File file) {
        return FileKit.isSymlink(file.toPath());
    }

    public static boolean isSub(File parent, File sub) {
        Assert.notNull(parent);
        Assert.notNull(sub);
        return FileKit.isSub(parent.toPath(), sub.toPath());
    }

    public static RandomAccessFile createRandomAccessFile(Path path, FileMode mode) {
        return FileKit.createRandomAccessFile(path.toFile(), mode);
    }

    public static RandomAccessFile createRandomAccessFile(File file, FileMode mode) {
        try {
            return new RandomAccessFile(file, mode.name());
        }
        catch (FileNotFoundException e) {
            throw new InternalException(e);
        }
    }

    public static void tail(File file, ConsumerX<String> handler) {
        FileKit.tail(file, org.miaixz.bus.core.lang.Charset.UTF_8, handler);
    }

    public static void tail(File file, Charset charset, ConsumerX<String> handler) {
        new FileTailer(file, charset, handler).start();
    }

    public static void tail(File file, Charset charset) {
        FileKit.tail(file, charset, FileTailer.CONSOLE_HANDLER);
    }

    public static FileSystem of(String path) {
        try {
            return FileSystems.newFileSystem(Paths.get(path, new String[0]).toUri(), MapKit.of("create", "true"));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static FileSystem createZip(String path) {
        return FileKit.createZip(path, null);
    }

    public static FileSystem createZip(String path, Charset charset) {
        if (null == charset) {
            charset = org.miaixz.bus.core.lang.Charset.UTF_8;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        env.put("encoding", charset.name());
        try {
            return FileSystems.newFileSystem(URI.create("jar:" + String.valueOf(Paths.get(path, new String[0]).toUri())), env);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static Path getRoot(FileSystem fileSystem) {
        return fileSystem.getPath("/", new String[0]);
    }

    private static File buildFile(File outFile, String fileName) {
        fileName = fileName.replace('\\', '/');
        if (!FileKit.isWindows() && fileName.lastIndexOf(47, fileName.length() - 2) > 0) {
            List<String> pathParts = CharsBacker.split(fileName, "/", false, true);
            int lastPartIndex = pathParts.size() - 1;
            for (int i = 0; i < lastPartIndex; ++i) {
                outFile = new File(outFile, pathParts.get(i));
            }
            outFile.mkdirs();
            fileName = pathParts.get(lastPartIndex);
        }
        return new File(outFile, fileName);
    }
}

