/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.beans.copier.ValueProvider;
import org.miaixz.bus.core.beans.copier.provider.MapValueProvider;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.lang.reflect.kotlin.KotlinCallable;
import org.miaixz.bus.core.lang.reflect.kotlin.KotlinClassImpl;
import org.miaixz.bus.core.lang.reflect.kotlin.KotlinParameter;

public class KotlinKit {
    private static final Class<? extends Annotation> META_DATA_CLASS = Optional.ofTry(() -> Class.forName("kotlin.Metadata")).get();
    public static final boolean IS_KOTLIN_ENABLE = null != META_DATA_CLASS;

    public static boolean isKotlinClass(Class<?> clazz) {
        return IS_KOTLIN_ENABLE && clazz.isAnnotationPresent(META_DATA_CLASS);
    }

    public static List<?> getConstructors(Class<?> targetType) {
        return KotlinClassImpl.getConstructors(targetType);
    }

    public static List<KotlinParameter> getParameters(Object kCallable) {
        return KotlinCallable.getParameters(kCallable);
    }

    public static Object[] getParameterValues(Object kCallable, ValueProvider<String> valueProvider) {
        List<KotlinParameter> parameters = KotlinKit.getParameters(kCallable);
        Object[] args = new Object[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            KotlinParameter kParameter = parameters.get(i);
            args[i] = valueProvider.value(kParameter.getName(), kParameter.getType());
        }
        return args;
    }

    public static <T> T newInstance(Class<T> targetType, Map<String, ?> map) {
        return KotlinKit.newInstance(targetType, new MapValueProvider(map));
    }

    public static <T> T newInstance(Class<T> targetType, ValueProvider<String> valueProvider) {
        List<?> constructors = KotlinKit.getConstructors(targetType);
        RuntimeException exception = null;
        for (Object constructor : constructors) {
            Object[] parameterValues = KotlinKit.getParameterValues(constructor, valueProvider);
            try {
                return (T)KotlinCallable.call(constructor, parameterValues);
            }
            catch (RuntimeException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }
}

