/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.math.Arrangement;
import org.miaixz.bus.core.math.Calculator;
import org.miaixz.bus.core.math.Combination;
import org.miaixz.bus.core.math.Money;
import org.miaixz.bus.core.math.NumberParser;
import org.miaixz.bus.core.math.NumberValidator;
import org.miaixz.bus.core.math.RomanNumberFormatter;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CompareKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class MathKit
extends NumberValidator {
    private static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};

    public static BigDecimal add(Number ... values) {
        if (ArrayKit.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = MathKit.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.add(MathKit.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal add(String ... values) {
        if (ArrayKit.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = MathKit.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (!StringKit.isNotBlank(value)) continue;
            result = result.add(MathKit.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal sub(Number ... values) {
        if (ArrayKit.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = MathKit.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(MathKit.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal sub(String ... values) {
        if (ArrayKit.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = MathKit.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (!StringKit.isNotBlank(value)) continue;
            result = result.subtract(MathKit.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal mul(Number ... values) {
        if (ArrayKit.isEmpty(values) || ArrayKit.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        if (MathKit.isZero(value)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = MathKit.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (MathKit.isZero(value)) {
                return BigDecimal.ZERO;
            }
            result = result.multiply(MathKit.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal mul(String ... values) {
        if (ArrayKit.isEmpty(values) || ArrayKit.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = MathKit.toBigDecimal(values[0]);
        if (MathKit.isZero(result)) {
            return BigDecimal.ZERO;
        }
        for (int i = 1; i < values.length; ++i) {
            BigDecimal ele = MathKit.toBigDecimal(values[i]);
            if (MathKit.isZero(ele)) {
                return BigDecimal.ZERO;
            }
            result = result.multiply(ele);
        }
        return result;
    }

    public static BigDecimal div(Number v1, Number v2) {
        return MathKit.div(v1, v2, 10);
    }

    public static BigDecimal div(String v1, String v2) {
        return MathKit.div(v1, v2, 10);
    }

    public static BigDecimal div(Number v1, Number v2, int scale) {
        return MathKit.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(String v1, String v2, int scale) {
        return MathKit.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(String v1, String v2, int scale, RoundingMode roundingMode) {
        return MathKit.div(MathKit.toBigDecimal(v1), MathKit.toBigDecimal(v2), scale, roundingMode);
    }

    public static BigDecimal div(Number v1, Number v2, int scale, RoundingMode roundingMode) {
        Assert.notNull(v2, "Divisor must be not null !", new Object[0]);
        if (null == v1 || MathKit.isZero(v1)) {
            return BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = -scale;
        }
        return MathKit.toBigDecimal(v1).divide(MathKit.toBigDecimal(v2), scale, roundingMode);
    }

    public static int ceilDiv(int v1, int v2) {
        return (int)Math.ceil((double)v1 / (double)v2);
    }

    public static BigDecimal round(double v, int scale) {
        return MathKit.round(v, scale, RoundingMode.HALF_UP);
    }

    public static String roundString(double v, int scale) {
        return MathKit.round(v, scale).toPlainString();
    }

    public static BigDecimal round(BigDecimal number, int scale) {
        return MathKit.round(number, scale, RoundingMode.HALF_UP);
    }

    public static String roundString(String numberStr, int scale) {
        return MathKit.roundString(numberStr, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(double v, int scale, RoundingMode roundingMode) {
        return MathKit.round(MathKit.toBigDecimal(v), scale, roundingMode);
    }

    public static String roundString(double v, int scale, RoundingMode roundingMode) {
        return MathKit.round(v, scale, roundingMode).toPlainString();
    }

    public static BigDecimal round(BigDecimal number, int scale, RoundingMode roundingMode) {
        if (null == number) {
            number = BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = 0;
        }
        if (null == roundingMode) {
            roundingMode = RoundingMode.HALF_UP;
        }
        return number.setScale(scale, roundingMode);
    }

    public static String roundString(String numberStr, int scale, RoundingMode roundingMode) {
        return MathKit.round(MathKit.toBigDecimal(numberStr), scale, roundingMode).toPlainString();
    }

    public static BigDecimal roundHalfEven(Number number, int scale) {
        return MathKit.round(MathKit.toBigDecimal(number), scale, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal roundDown(Number number, int scale) {
        return MathKit.round(MathKit.toBigDecimal(number), scale, RoundingMode.DOWN);
    }

    public static String format(String pattern, double value) {
        Assert.isTrue(MathKit.isValid(value), "value is NaN or Infinite!", new Object[0]);
        return new DecimalFormat(pattern).format(value);
    }

    public static String format(String pattern, long value) {
        return new DecimalFormat(pattern).format(value);
    }

    public static String format(String pattern, Object value) {
        return MathKit.format(pattern, value, null);
    }

    public static String format(String pattern, Object value, RoundingMode roundingMode) {
        if (value instanceof Number) {
            Assert.isTrue(MathKit.isValidNumber((Number)value), "value is NaN or Infinite!", new Object[0]);
        }
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        if (null != roundingMode) {
            decimalFormat.setRoundingMode(roundingMode);
        }
        return decimalFormat.format(value);
    }

    public static String formatMoney(double value) {
        return MathKit.format(",##0.00", value);
    }

    public static String formatPercent(double number, int scale) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits(scale);
        return format.format(number);
    }

    public static String formatThousands(double number, int scale) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(scale);
        return format.format(number);
    }

    public static int[] range(int stopIncluded) {
        return MathKit.range(0, stopIncluded, 1);
    }

    public static int[] range(int startInclude, int stopIncluded) {
        return MathKit.range(startInclude, stopIncluded, 1);
    }

    public static int[] range(int startInclude, int stopIncluded, int step) {
        if (startInclude > stopIncluded) {
            int tmp = startInclude;
            startInclude = stopIncluded;
            stopIncluded = tmp;
        }
        if (step <= 0) {
            step = 1;
        }
        int deviation = stopIncluded + 1 - startInclude;
        int length = deviation / step;
        if (deviation % step != 0) {
            ++length;
        }
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = startInclude;
            startInclude += step;
        }
        return range;
    }

    public static Collection<Integer> appendRange(int start, int stop, Collection<Integer> values) {
        return MathKit.appendRange(start, stop, 1, values);
    }

    public static Collection<Integer> appendRange(int startInclude, int stopInclude, int step, Collection<Integer> values) {
        if (startInclude < stopInclude) {
            step = Math.abs(step);
        } else if (startInclude > stopInclude) {
            step = -Math.abs(step);
        } else {
            values.add(startInclude);
            return values;
        }
        int i = startInclude;
        while (step > 0 ? i <= stopInclude : i >= stopInclude) {
            values.add(i);
            i += step;
        }
        return values;
    }

    public static String getBinaryString(Number number) {
        if (number instanceof Long) {
            return Long.toBinaryString((Long)number);
        }
        if (number instanceof Integer) {
            return Integer.toBinaryString((Integer)number);
        }
        return Long.toBinaryString(number.longValue());
    }

    public static int binaryToInt(String binaryStr) {
        return Integer.parseInt(binaryStr, 2);
    }

    public static long binaryToLong(String binaryStr) {
        return Long.parseLong(binaryStr, 2);
    }

    public static boolean equals(Number number1, Number number2) {
        if (number1 instanceof BigDecimal && number2 instanceof BigDecimal) {
            return CompareKit.equals((BigDecimal)number1, (BigDecimal)number2);
        }
        return Objects.equals(number1, number2);
    }

    public static String toString(Number number, String defaultValue) {
        return null == number ? defaultValue : MathKit.toString(number);
    }

    public static String toString(Number number) {
        return MathKit.toString(number, true);
    }

    public static String toString(Number number, boolean isStripTrailingZeros) {
        Assert.notNull(number, "Number is null !", new Object[0]);
        if (number instanceof BigDecimal) {
            return MathKit.toString((BigDecimal)number, isStripTrailingZeros);
        }
        Assert.isTrue(MathKit.isValidNumber(number), "Number is non-finite!", new Object[0]);
        String string = number.toString();
        if (isStripTrailingZeros && string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static String toString(BigDecimal bigDecimal) {
        return MathKit.toString(bigDecimal, true);
    }

    public static String toString(BigDecimal bigDecimal, boolean isStripTrailingZeros) {
        Assert.notNull(bigDecimal, "BigDecimal is null !", new Object[0]);
        if (isStripTrailingZeros) {
            bigDecimal = bigDecimal.stripTrailingZeros();
        }
        return bigDecimal.toPlainString();
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return new BigDecimal(number.toString());
    }

    public static BigDecimal toBigDecimal(String numberStr) throws IllegalArgumentException {
        Assert.notBlank(numberStr, "Number text must be not blank!", new Object[0]);
        try {
            return new BigDecimal(numberStr);
        }
        catch (Exception exception) {
            return MathKit.toBigDecimal(MathKit.parseNumber(numberStr));
        }
    }

    public static BigInteger toBigInteger(Number number) {
        Assert.notNull(number, "Number must be not null!", new Object[0]);
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof Long) {
            return BigInteger.valueOf((Long)number);
        }
        return MathKit.toBigInteger(number.longValue());
    }

    public static BigInteger toBigInteger(String numberStr) {
        Assert.notBlank(numberStr, "Number text must be not blank!", new Object[0]);
        try {
            return new BigInteger(numberStr);
        }
        catch (Exception exception) {
            return MathKit.parseBigInteger(numberStr);
        }
    }

    public static int count(int total, int pageSize) {
        return (total + pageSize - 1) / pageSize;
    }

    public static int zeroToOne(int value) {
        return 0 == value ? 1 : value;
    }

    public static int nullToZero(Integer number) {
        return number == null ? 0 : number;
    }

    public static long nullToZero(Long number) {
        return number == null ? 0L : number;
    }

    public static double nullToZero(Double number) {
        return number == null ? 0.0 : number;
    }

    public static float nullToZero(Float number) {
        return number == null ? 0.0f : number.floatValue();
    }

    public static short nullToZero(Short number) {
        return number == null ? (short)0 : number;
    }

    public static byte nullToZero(Byte number) {
        return number == null ? (byte)0 : number;
    }

    public static BigInteger nullToZero(BigInteger number) {
        return ObjectKit.defaultIfNull(number, BigInteger.ZERO);
    }

    public static BigDecimal nullToZero(BigDecimal decimal) {
        return ObjectKit.defaultIfNull(decimal, BigDecimal.ZERO);
    }

    public static BigInteger parseBigInteger(String numberStr) {
        return NumberParser.INSTANCE.parseBigInteger(numberStr);
    }

    public static boolean isBeside(long number1, long number2) {
        return Math.abs(number1 - number2) == 1L;
    }

    public static boolean isBeside(int number1, int number2) {
        return Math.abs(number1 - number2) == 1;
    }

    public static int partValue(int total, int partCount) {
        return MathKit.partValue(total, partCount, true);
    }

    public static int partValue(int total, int partCount, boolean isPlusOneWhenHasRem) {
        int partValue = total / partCount;
        if (isPlusOneWhenHasRem && total % partCount > 0) {
            ++partValue;
        }
        return partValue;
    }

    public static BigDecimal pow(Number number, int n) {
        return MathKit.pow(MathKit.toBigDecimal(number), n);
    }

    public static BigDecimal pow(BigDecimal number, int n) {
        return number.pow(n);
    }

    public static boolean isPowerOfTwo(long n) {
        return n > 0L && (n & n - 1L) == 0L;
    }

    public static Integer parseInt(String numberStr, Integer defaultValue) {
        if (StringKit.isNotBlank(numberStr)) {
            try {
                return MathKit.parseInt(numberStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int parseInt(String numberStr) throws NumberFormatException {
        return NumberParser.INSTANCE.parseInt(numberStr);
    }

    public static Long parseLong(String numberStr, Long defaultValue) {
        if (StringKit.isNotBlank(numberStr)) {
            try {
                return MathKit.parseLong(numberStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long parseLong(String numberStr) {
        return NumberParser.INSTANCE.parseLong(numberStr);
    }

    public static Float parseFloat(String numberStr, Float defaultValue) {
        if (StringKit.isNotBlank(numberStr)) {
            try {
                return Float.valueOf(MathKit.parseFloat(numberStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float parseFloat(String numberStr) {
        return NumberParser.INSTANCE.parseFloat(numberStr);
    }

    public static Double parseDouble(String numberStr, Double defaultValue) {
        if (StringKit.isNotBlank(numberStr)) {
            try {
                return MathKit.parseDouble(numberStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double parseDouble(String numberStr) {
        return NumberParser.INSTANCE.parseDouble(numberStr);
    }

    public static Number parseNumber(String numberStr, Number defaultValue) {
        if (StringKit.isNotBlank(numberStr)) {
            try {
                return MathKit.parseNumber(numberStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Number parseNumber(String numberStr) throws NumberFormatException {
        return NumberParser.INSTANCE.parseNumber(numberStr);
    }

    public static Number parseNumber(String numberStr, Locale locale) throws NumberFormatException {
        return NumberParser.of(locale).parseNumber(numberStr);
    }

    public static boolean isValidNumber(Number number) {
        if (null == number) {
            return false;
        }
        if (number instanceof Double) {
            return !((Double)number).isInfinite() && !((Double)number).isNaN();
        }
        if (number instanceof Float) {
            return !((Float)number).isInfinite() && !((Float)number).isNaN();
        }
        return true;
    }

    public static boolean isValid(double number) {
        return !Double.isNaN(number) && !Double.isInfinite(number);
    }

    public static boolean isValid(float number) {
        return !Float.isNaN(number) && !Float.isInfinite(number);
    }

    public static double calculate(String expression) {
        return Calculator.conversion(expression);
    }

    public static double toDouble(Number value) {
        if (value instanceof Float) {
            return Double.parseDouble(value.toString());
        }
        return value.doubleValue();
    }

    public static boolean isOdd(int num) {
        return (num & 1) == 1;
    }

    public static boolean isEven(int num) {
        return !MathKit.isOdd(num);
    }

    public static boolean isZero(Number n) {
        Assert.notNull(n);
        if (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long) {
            return 0L == n.longValue();
        }
        if (n instanceof BigInteger) {
            return MathKit.equals(BigInteger.ZERO, n);
        }
        if (n instanceof Float) {
            return 0.0f == n.floatValue();
        }
        if (n instanceof Double) {
            return 0.0 == n.doubleValue();
        }
        return MathKit.equals(MathKit.toBigDecimal(n), BigDecimal.ZERO);
    }

    public static String intToRoman(int num) {
        return RomanNumberFormatter.intToRoman(num);
    }

    public static int romanToInt(String roman) {
        return RomanNumberFormatter.romanToInt(roman);
    }

    public static long arrangementCount(int n, int m) {
        return Arrangement.count(n, m);
    }

    public static long arrangementCount(int n) {
        return Arrangement.count(n);
    }

    public static List<String[]> arrangementSelect(String[] datas, int m) {
        return new Arrangement(datas).select(m);
    }

    public static List<String[]> arrangementSelect(String[] datas) {
        return new Arrangement(datas).select();
    }

    public static long combinationCount(int n, int m) {
        return Combination.count(n, m);
    }

    public static List<String[]> combinationSelect(String[] datas, int m) {
        return new Combination(datas).select(m);
    }

    public static long yuanToCent(double yuan) {
        return new Money(yuan).getCent();
    }

    public static double centToYuan(long cent) {
        long yuan = cent / 100L;
        int centPart = (int)(cent % 100L);
        return new Money(yuan, centPart).getAmount().doubleValue();
    }

    public static BigInteger factorial(BigInteger n) {
        if (n.equals(BigInteger.ZERO)) {
            return BigInteger.ONE;
        }
        return MathKit.factorial(n, BigInteger.ZERO);
    }

    public static BigInteger factorial(BigInteger start, BigInteger end) {
        Assert.notNull(start, "Factorial start must be not null!", new Object[0]);
        Assert.notNull(end, "Factorial end must be not null!", new Object[0]);
        if (start.compareTo(BigInteger.ZERO) < 0 || end.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException(StringKit.format("Factorial start and end both must be > 0, but got start={}, end={}", start, end));
        }
        if (start.equals(BigInteger.ZERO)) {
            start = BigInteger.ONE;
        }
        if (end.compareTo(BigInteger.ONE) < 0) {
            end = BigInteger.ONE;
        }
        BigInteger result = start;
        end = end.add(BigInteger.ONE);
        while (start.compareTo(end) > 0) {
            start = start.subtract(BigInteger.ONE);
            result = result.multiply(start);
        }
        return result;
    }

    public static long factorial(long start, long end) {
        if (start < 0L || end < 0L) {
            throw new IllegalArgumentException(StringKit.format("Factorial start and end both must be >= 0, but got start={}, end={}", start, end));
        }
        if (0L == start || start == end) {
            return 1L;
        }
        if (start < end) {
            return 0L;
        }
        return MathKit.factorialMultiplyAndCheck(start, MathKit.factorial(start - 1L, end));
    }

    private static long factorialMultiplyAndCheck(long a, long b) {
        if (a <= Long.MAX_VALUE / b) {
            return a * b;
        }
        throw new IllegalArgumentException(StringKit.format("Overflow in multiplication: {} * {}", a, b));
    }

    public static long factorial(long n) {
        if (n < 0L || n > 20L) {
            throw new IllegalArgumentException(StringKit.format("Factorial must have n >= 0 and n <= 20 for n!, but got n = {}", n));
        }
        return FACTORIALS[(int)n];
    }

    public static long sqrt(long x) {
        long y = 0L;
        for (long b = 0x4000000000000000L; b > 0L; b >>= 2) {
            if (x >= y + b) {
                x -= y + b;
                y >>= 1;
                y += b;
                continue;
            }
            y >>= 1;
        }
        return y;
    }

    public static int processMultiple(int selectNum, int minNum) {
        int result = MathKit.mathSubNode(selectNum, minNum) / MathKit.mathNode(selectNum - minNum);
        return result;
    }

    public static int gcd(int a, int b) {
        Assert.isTrue(a >= 0, "a must be >= 0", new Object[0]);
        Assert.isTrue(b >= 0, "b must be >= 0", new Object[0]);
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        int aTwos = Integer.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b);
        b >>= bTwos;
        while (a != b) {
            int delta = a - b;
            int minDeltaOrZero = delta & delta >> 31;
            a = delta - minDeltaOrZero - minDeltaOrZero;
            b += minDeltaOrZero;
            a >>= Integer.numberOfTrailingZeros(a);
        }
        return a << Math.min(aTwos, bTwos);
    }

    public static int multiple(int m, int n) {
        return m * n / MathKit.gcd(m, n);
    }

    private static int mathSubNode(int selectNum, int minNum) {
        if (selectNum == minNum) {
            return 1;
        }
        return selectNum * MathKit.mathSubNode(selectNum - 1, minNum);
    }

    private static int mathNode(int selectNum) {
        if (selectNum == 0) {
            return 1;
        }
        return selectNum * MathKit.mathNode(selectNum - 1);
    }
}

