/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.miaixz.bus.core.lang.EnumMap;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ReflectKit;

public class ModifierKit {
    public static boolean hasModifier(Class<?> clazz, EnumMap.Modifier ... modifierTypes) {
        if (null == clazz || ArrayKit.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (clazz.getModifiers() & EnumMap.Modifier.orToInt(modifierTypes));
    }

    public static boolean hasModifier(Member member, EnumMap.Modifier ... modifierTypes) {
        if (null == member || ArrayKit.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (member.getModifiers() & EnumMap.Modifier.orToInt(modifierTypes));
    }

    public static boolean hasModifier(int modifiers, int ... checkedModifiers) {
        if (ArrayKit.isEmpty(checkedModifiers)) {
            return false;
        }
        return 0 != (modifiers & EnumMap.Modifier.orToInt(checkedModifiers));
    }

    public static boolean hasAllModifier(int modifiers, int ... checkedModifiers) {
        if (ArrayKit.isEmpty(checkedModifiers)) {
            return false;
        }
        int checkedModifiersInt = EnumMap.Modifier.orToInt(checkedModifiers);
        return checkedModifiersInt == (modifiers & checkedModifiersInt);
    }

    public static boolean isDefault(Method method) {
        return null != method && method.isDefault();
    }

    public static boolean isPublic(Member member) {
        return null != member && Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPublic(Class<?> clazz) {
        return null != clazz && Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return null != member && Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isPrivate(Class<?> clazz) {
        return null != clazz && Modifier.isPrivate(clazz.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return null != member && Modifier.isStatic(member.getModifiers());
    }

    public static boolean isStatic(Class<?> clazz) {
        return null != clazz && Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isSynthetic(Member member) {
        return null != member && member.isSynthetic();
    }

    public static boolean isSynthetic(Class<?> clazz) {
        return null != clazz && clazz.isSynthetic();
    }

    public static boolean isAbstract(Member member) {
        return null != member && Modifier.isAbstract(member.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return null != clazz && Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isInterface(Class<?> clazz) {
        return null != clazz && clazz.isInterface();
    }

    public static void removeFinalModify(Field field) {
        Field modifiersField;
        if (!ModifierKit.hasModifier(field, EnumMap.Modifier.FINAL)) {
            return;
        }
        ReflectKit.setAccessible(field);
        try {
            modifiersField = Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            throw new InternalException(e, "Field [modifiers] not exist!", new Object[0]);
        }
        try {
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (IllegalAccessException e) {
            throw new InternalException(e, "IllegalAccess for [{}.{}]", field.getDeclaringClass(), field.getName());
        }
    }
}

