/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.DatagramSocket;
import java.net.HttpCookie;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.miaixz.bus.core.center.iterator.EnumerationIterator;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Keys;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.net.NonAuthenticator;
import org.miaixz.bus.core.net.ip.IPv4;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.RandomKit;
import org.miaixz.bus.core.xyz.StringKit;

public class NetKit {
    public static String longToIpv4(long longIP) {
        return IPv4.longToIpv4(longIP);
    }

    public static long ipv4ToLong(String strIP) {
        return IPv4.ipv4ToLong(strIP);
    }

    public static boolean isUsableLocalPort(int port) {
        if (!NetKit.isValidPort(port)) {
            return false;
        }
        try (ServerSocket ss = new ServerSocket(port);){
            ss.setReuseAddress(true);
        }
        catch (IOException ignored) {
            return false;
        }
        try (DatagramSocket ds = new DatagramSocket(port);){
            ds.setReuseAddress(true);
        }
        catch (IOException ignored) {
            return false;
        }
        return true;
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static int getUsableLocalPort() {
        return NetKit.getUsableLocalPort(1024);
    }

    public static int getUsableLocalPort(int minPort) {
        return NetKit.getUsableLocalPort(minPort, 65535);
    }

    public static int getUsableLocalPort(int minPort, int maxPort) {
        int maxPortExclude = maxPort + 1;
        for (int i = minPort; i < maxPortExclude; ++i) {
            int randomPort = RandomKit.randomInt(minPort, maxPortExclude);
            if (!NetKit.isUsableLocalPort(randomPort)) continue;
            return randomPort;
        }
        throw new InternalException("Could not find an available port in the range [{}, {}] after {} attempts", minPort, maxPort, maxPort - minPort);
    }

    public static TreeSet<Integer> getUsableLocalPorts(int numRequested, int minPort, int maxPort) {
        TreeSet<Integer> availablePorts = new TreeSet<Integer>();
        int attemptCount = 0;
        while (++attemptCount <= numRequested + 100 && availablePorts.size() < numRequested) {
            availablePorts.add(NetKit.getUsableLocalPort(minPort, maxPort));
        }
        if (availablePorts.size() != numRequested) {
            throw new InternalException("Could not find {} available  ports in the range [{}, {}]", numRequested, minPort, maxPort);
        }
        return availablePorts;
    }

    public static boolean isInnerIP(String ipAddress) {
        return IPv4.isInnerIP(ipAddress);
    }

    public static String toAbsoluteUrl(String absoluteBasePath, String relativePath) {
        try {
            URL absoluteUrl = new URL(absoluteBasePath);
            return new URL(absoluteUrl, relativePath).toString();
        }
        catch (Exception e) {
            throw new InternalException(e, "To absolute url [{}] base [{}] error!", relativePath, absoluteBasePath);
        }
    }

    public static String hideIpPart(String ip) {
        return StringKit.builder(ip.length()).append(ip, 0, ip.lastIndexOf(".") + 1).append("*").toString();
    }

    public static String hideIpPart(long ip) {
        return NetKit.hideIpPart(NetKit.longToIpv4(ip));
    }

    public static String getIpByHost(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            return hostName;
        }
    }

    public static NetworkInterface getNetworkInterface(String name) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = networkInterfaces.nextElement();
            if (null == netInterface || !name.equals(netInterface.getName())) continue;
            return netInterface;
        }
        return null;
    }

    public static Collection<NetworkInterface> getNetworkInterfaces() {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        return CollKit.addAll(new ArrayList(), networkInterfaces);
    }

    public static LinkedHashSet<String> localIpv4s() {
        LinkedHashSet<InetAddress> localAddressList = NetKit.localAddressList(t -> t instanceof Inet4Address);
        return NetKit.toIpList(localAddressList);
    }

    public static LinkedHashSet<String> toIpList(Set<InetAddress> addressList) {
        LinkedHashSet<String> ipSet = new LinkedHashSet<String>();
        for (InetAddress address : addressList) {
            ipSet.add(address.getHostAddress());
        }
        return ipSet;
    }

    public static LinkedHashSet<String> localIps() {
        LinkedHashSet<InetAddress> localAddressList = NetKit.localAddressList(null);
        return NetKit.toIpList(localAddressList);
    }

    public static LinkedHashSet<InetAddress> localAddressList(Predicate<InetAddress> addressPredicate) {
        return NetKit.localAddressList(null, addressPredicate);
    }

    public static LinkedHashSet<InetAddress> localAddressList(Predicate<NetworkInterface> networkInterfaceFilter, Predicate<InetAddress> addressPredicate) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new InternalException(e);
        }
        Assert.notNull(networkInterfaces, () -> new InternalException("Get network interface error!"));
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (networkInterfaceFilter != null && !networkInterfaceFilter.test(networkInterface)) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressPredicate && !addressPredicate.test(inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }

    public static String getLocalhostStringV4() {
        InetAddress localhost = IPv4.getLocalhost();
        if (null != localhost) {
            return localhost.getHostAddress();
        }
        return null;
    }

    public static InetAddress getLocalhostV4() {
        return IPv4.getLocalhost();
    }

    public static String getLocalMacAddressV4() {
        return IPv4.getLocalMacAddress();
    }

    public static InetSocketAddress createAddress(String host, int port) {
        if (StringKit.isBlank(host)) {
            return new InetSocketAddress(port);
        }
        return new InetSocketAddress(host, port);
    }

    public static void netCat(String host, int port, boolean isBlock, ByteBuffer data) throws InternalException {
        try (SocketChannel channel = SocketChannel.open(NetKit.createAddress(host, port));){
            channel.configureBlocking(isBlock);
            channel.write(data);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static void netCat(String host, int port, byte[] data) throws InternalException {
        OutputStream out = null;
        try (Socket socket = new Socket(host, port);){
            out = socket.getOutputStream();
            out.write(data);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly(out);
                throw throwable;
            }
        }
        IoKit.closeQuietly(out);
    }

    public static boolean isInRange(String ip, String cidr) {
        int maskSplitMarkIndex = cidr.lastIndexOf("/");
        if (maskSplitMarkIndex < 0) {
            throw new IllegalArgumentException("Invalid cidr: " + cidr);
        }
        long mask = -1L << 32 - Integer.parseInt(cidr.substring(maskSplitMarkIndex + 1));
        long cidrIpAddr = NetKit.ipv4ToLong(cidr.substring(0, maskSplitMarkIndex));
        return (NetKit.ipv4ToLong(ip) & mask) == (cidrIpAddr & mask);
    }

    public static String idnToASCII(String unicode) {
        return IDN.toASCII(unicode);
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && StringKit.indexOf(ip, ',') > 0) {
            List<String> ips = CharsBacker.splitTrim(ip, ",");
            for (String subIp : ips) {
                if (NetKit.isUnknown(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknown(String checkString) {
        return StringKit.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static boolean ping(String ip) {
        return NetKit.ping(ip, 200);
    }

    public static boolean ping(String ip, int timeout) {
        try {
            return InetAddress.getByName(ip).isReachable(timeout);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static List<HttpCookie> parseCookies(String cookieStr) {
        if (StringKit.isBlank(cookieStr)) {
            return Collections.emptyList();
        }
        return HttpCookie.parse(cookieStr);
    }

    public static boolean isOpen(InetSocketAddress address, int timeout) {
        boolean bl;
        Socket sc = new Socket();
        try {
            sc.connect(address, timeout);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sc.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        sc.close();
        return bl;
    }

    public static void setGlobalAuthenticator(String user, char[] pass) {
        NetKit.setGlobalAuthenticator(new NonAuthenticator(user, pass));
    }

    public static void setGlobalAuthenticator(Authenticator authenticator) {
        Authenticator.setDefault(authenticator);
    }

    public static List<String> getDnsInfo(String hostName, String ... attrNames) {
        String uri = StringKit.addPrefixIfNot(hostName, "dns:");
        Attributes attributes = Keys.getAttributes(uri, attrNames);
        ArrayList<String> infos = new ArrayList<String>();
        for (Attribute attribute : new EnumerationIterator<Attribute>(attributes.getAll())) {
            try {
                infos.add((String)attribute.get());
            }
            catch (NamingException namingException) {}
        }
        return infos;
    }

    public static String getAddressName(InetAddress address) {
        if (null == address) {
            return null;
        }
        String name = address.getHostName();
        if (StringKit.isEmpty(name)) {
            name = address.getHostAddress();
        }
        return name;
    }

    public static String getMacAddress(InetAddress inetAddress) {
        return NetKit.getMacAddress(inetAddress, "-");
    }

    public static String getMacAddress(InetAddress inetAddress, String separator) {
        if (null == inetAddress) {
            return null;
        }
        return NetKit.toMacAddress(NetKit.getHardwareAddress(inetAddress), separator);
    }

    public static byte[] getHardwareAddress(InetAddress inetAddress) {
        if (null == inetAddress) {
            return null;
        }
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            if (null != networkInterface) {
                return networkInterface.getHardwareAddress();
            }
        }
        catch (SocketException e) {
            throw new InternalException(e);
        }
        return null;
    }

    public static String toMacAddress(byte[] mac, String separator) {
        if (null == mac) {
            return null;
        }
        StringBuilder sb = new StringBuilder(mac.length * 2 + (mac.length - 1) * separator.length());
        for (int i = 0; i < mac.length; ++i) {
            String s;
            if (i != 0) {
                sb.append(separator);
            }
            sb.append((String)((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? "0" + s : s));
        }
        return sb.toString();
    }
}

