/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.miaixz.bus.core.center.function.FunctionX;
import org.miaixz.bus.core.compare.LengthCompare;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.mutable.Mutable;
import org.miaixz.bus.core.lang.mutable.MutableObject;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CompareKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.SetKit;
import org.miaixz.bus.core.xyz.StringKit;

public class PatternKit {
    public static final Set<Character> RE_KEYS = SetKit.of(Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'));

    public static String getGroup0(String regex, CharSequence content) {
        return PatternKit.get(regex, content, 0);
    }

    public static String getGroup1(String regex, CharSequence content) {
        return PatternKit.get(regex, content, 1);
    }

    public static String get(String regex, CharSequence content, int groupIndex) {
        if (null == content || null == regex) {
            return null;
        }
        Pattern pattern = org.miaixz.bus.core.center.regex.Pattern.get(regex, 32);
        return PatternKit.get(pattern, content, groupIndex);
    }

    public static String get(String regex, CharSequence content, String groupName) {
        if (null == content || null == regex) {
            return null;
        }
        Pattern pattern = org.miaixz.bus.core.center.regex.Pattern.get(regex, 32);
        return PatternKit.get(pattern, content, groupName);
    }

    public static String getGroup0(Pattern pattern, CharSequence content) {
        return PatternKit.get(pattern, content, 0);
    }

    public static String getGroup1(Pattern pattern, CharSequence content) {
        return PatternKit.get(pattern, content, 1);
    }

    public static String get(Pattern pattern, CharSequence content, int groupIndex) {
        if (null == content || null == pattern) {
            return null;
        }
        MutableObject result = new MutableObject();
        PatternKit.get(pattern, content, (Matcher matcher) -> result.set(matcher.group(groupIndex)));
        return (String)result.get();
    }

    public static String get(Pattern pattern, CharSequence content, String groupName) {
        if (null == content || null == pattern || null == groupName) {
            return null;
        }
        MutableObject result = new MutableObject();
        PatternKit.get(pattern, content, (Matcher matcher) -> result.set(matcher.group(groupName)));
        return (String)result.get();
    }

    public static void get(Pattern pattern, CharSequence content, Consumer<Matcher> consumer) {
        if (null == content || null == pattern || null == consumer) {
            return;
        }
        Matcher m = pattern.matcher(content);
        if (m.find()) {
            consumer.accept(m);
        }
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content) {
        return PatternKit.getAllGroups(pattern, content, true);
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content, boolean withGroup0) {
        return PatternKit.getAllGroups(pattern, content, withGroup0, false);
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content, boolean withGroup0, boolean findAll) {
        if (null == content || null == pattern) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            int startGroup = withGroup0 ? 0 : 1;
            int groupCount = matcher.groupCount();
            for (int i = startGroup; i <= groupCount; ++i) {
                result.add(matcher.group(i));
            }
            if (findAll) continue;
            break;
        }
        return result;
    }

    public static Map<String, String> getAllGroupNames(Pattern pattern, CharSequence content) {
        if (null == content || null == pattern) {
            return null;
        }
        Matcher m = pattern.matcher(content);
        HashMap<String, String> result = MapKit.newHashMap(m.groupCount());
        if (m.find()) {
            Map map = (Map)MethodKit.invoke((Object)pattern, "namedGroups", new Object[0]);
            map.forEach((key, value) -> result.put((String)key, m.group((int)value)));
        }
        return result;
    }

    public static String extractMulti(Pattern pattern, CharSequence content, String template) {
        if (null == content || null == pattern || null == template) {
            return null;
        }
        TreeSet<Integer> varNums = new TreeSet<Integer>((o1, o2) -> CompareKit.compare(o2, o1));
        Matcher matcherForTemplate = org.miaixz.bus.core.center.regex.Pattern.GROUP_VAR_PATTERN.matcher(template);
        while (matcherForTemplate.find()) {
            varNums.add(Integer.parseInt(matcherForTemplate.group(1)));
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (Integer group : varNums) {
                template = template.replace("$" + group, matcher.group(group));
            }
            return template;
        }
        return null;
    }

    public static String extractMulti(String regex, CharSequence content, String template) {
        if (null == content || null == regex || null == template) {
            return null;
        }
        Pattern pattern = org.miaixz.bus.core.center.regex.Pattern.get(regex, 32);
        return PatternKit.extractMulti(pattern, content, template);
    }

    public static String extractMultiAndDelPre(Pattern pattern, Mutable<CharSequence> contentHolder, String template) {
        if (null == contentHolder || null == pattern || null == template) {
            return null;
        }
        HashSet<String> varNums = PatternKit.findAll(org.miaixz.bus.core.center.regex.Pattern.GROUP_VAR_PATTERN, (CharSequence)template, 1, new HashSet());
        CharSequence content = contentHolder.get();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (String var : varNums) {
                int group = Integer.parseInt(var);
                template = template.replace("$" + var, matcher.group(group));
            }
            contentHolder.set(StringKit.sub(content, matcher.end(), content.length()));
            return template;
        }
        return null;
    }

    public static String extractMultiAndDelPre(String regex, Mutable<CharSequence> contentHolder, String template) {
        if (null == contentHolder || null == regex || null == template) {
            return null;
        }
        Pattern pattern = org.miaixz.bus.core.center.regex.Pattern.get(regex, 32);
        return PatternKit.extractMultiAndDelPre(pattern, contentHolder, template);
    }

    public static String delFirst(String regex, CharSequence content) {
        if (ArrayKit.hasBlank(regex, content)) {
            return StringKit.toString(content);
        }
        Pattern pattern = org.miaixz.bus.core.center.regex.Pattern.get(regex, 32);
        return PatternKit.delFirst(pattern, content);
    }

    public static String delFirst(Pattern pattern, CharSequence content) {
        return PatternKit.replaceFirst(pattern, content, "");
    }

    public static String replaceFirst(Pattern pattern, CharSequence content, String replacement) {
        if (null == pattern || StringKit.isEmpty(content)) {
            return StringKit.toString(content);
        }
        return pattern.matcher(content).replaceFirst(replacement);
    }

    public static String delLast(String regex, CharSequence text) {
        if (ArrayKit.hasBlank(regex, text)) {
            return StringKit.toString(text);
        }
        Pattern pattern = org.miaixz.bus.core.center.regex.Pattern.get(regex, 32);
        return PatternKit.delLast(pattern, text);
    }

    public static String delLast(Pattern pattern, CharSequence text) {
        MatchResult matchResult;
        if (null != pattern && StringKit.isNotEmpty(text) && null != (matchResult = PatternKit.lastIndexOf(pattern, text))) {
            return StringKit.subPre(text, matchResult.start()) + StringKit.subSuf(text, matchResult.end());
        }
        return StringKit.toString(text);
    }

    public static String delAll(String regex, CharSequence content) {
        if (StringKit.hasEmpty(regex, content)) {
            return StringKit.toString(content);
        }
        Pattern pattern = org.miaixz.bus.core.center.regex.Pattern.get(regex, 32);
        return PatternKit.delAll(pattern, content);
    }

    public static String delAll(Pattern pattern, CharSequence content) {
        if (null == pattern || StringKit.isEmpty(content)) {
            return StringKit.toString(content);
        }
        return pattern.matcher(content).replaceAll("");
    }

    public static String delPre(String regex, CharSequence content) {
        if (null == content || null == regex) {
            return StringKit.toString(content);
        }
        Pattern pattern = org.miaixz.bus.core.center.regex.Pattern.get(regex, 32);
        return PatternKit.delPre(pattern, content);
    }

    public static String delPre(Pattern pattern, CharSequence content) {
        if (null == content || null == pattern) {
            return StringKit.toString(content);
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return StringKit.sub(content, matcher.end(), content.length());
        }
        return StringKit.toString(content);
    }

    public static List<String> findAllGroup0(String regex, CharSequence content) {
        return PatternKit.findAll(regex, content, 0);
    }

    public static List<String> findAllGroup1(String regex, CharSequence content) {
        return PatternKit.findAll(regex, content, 1);
    }

    public static List<String> findAll(String regex, CharSequence content, int group) {
        return PatternKit.findAll(regex, content, group, new ArrayList());
    }

    public static <T extends Collection<String>> T findAll(String regex, CharSequence content, int group, T collection) {
        if (null == regex) {
            return collection;
        }
        return PatternKit.findAll(org.miaixz.bus.core.center.regex.Pattern.get(regex, 32), content, group, collection);
    }

    public static List<String> findAllGroup0(Pattern pattern, CharSequence content) {
        return PatternKit.findAll(pattern, content, 0);
    }

    public static List<String> findAllGroup1(Pattern pattern, CharSequence content) {
        return PatternKit.findAll(pattern, content, 1);
    }

    public static List<String> findAll(Pattern pattern, CharSequence content, int group) {
        return PatternKit.findAll(pattern, content, group, new ArrayList());
    }

    public static <T extends Collection<String>> T findAll(Pattern pattern, CharSequence content, int group, T collection) {
        if (null == pattern || null == content) {
            return null;
        }
        Assert.notNull(collection, "Collection must be not null !", new Object[0]);
        PatternKit.findAll(pattern, content, matcher -> collection.add(matcher.group(group)));
        return collection;
    }

    public static void findAll(Pattern pattern, CharSequence content, Consumer<Matcher> consumer) {
        if (null == pattern || null == content) {
            return;
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            consumer.accept(matcher);
        }
    }

    public static int count(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return 0;
        }
        Pattern pattern = org.miaixz.bus.core.center.regex.Pattern.get(regex, 32);
        return PatternKit.count(pattern, content);
    }

    public static int count(Pattern pattern, CharSequence content) {
        if (null == pattern || null == content) {
            return 0;
        }
        int count = 0;
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static boolean contains(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return false;
        }
        Pattern pattern = org.miaixz.bus.core.center.regex.Pattern.get(regex, 32);
        return PatternKit.contains(pattern, content);
    }

    public static boolean contains(Pattern pattern, CharSequence content) {
        if (null == pattern || null == content) {
            return false;
        }
        return pattern.matcher(content).find();
    }

    public static MatchResult indexOf(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return null;
        }
        Pattern pattern = org.miaixz.bus.core.center.regex.Pattern.get(regex, 32);
        return PatternKit.indexOf(pattern, content);
    }

    public static MatchResult indexOf(Pattern pattern, CharSequence content) {
        Matcher matcher;
        if (null != pattern && null != content && (matcher = pattern.matcher(content)).find()) {
            return matcher.toMatchResult();
        }
        return null;
    }

    public static MatchResult lastIndexOf(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return null;
        }
        Pattern pattern = org.miaixz.bus.core.center.regex.Pattern.get(regex, 32);
        return PatternKit.lastIndexOf(pattern, content);
    }

    public static MatchResult lastIndexOf(Pattern pattern, CharSequence content) {
        MatchResult result = null;
        if (null != pattern && null != content) {
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                result = matcher.toMatchResult();
            }
        }
        return result;
    }

    public static Integer getFirstNumber(CharSequence stringWithNumber) {
        return Convert.toInt(PatternKit.get(org.miaixz.bus.core.center.regex.Pattern.NUMBERS_PATTERN, stringWithNumber, 0), null);
    }

    public static boolean isMatch(String regex, CharSequence content) {
        if (content == null) {
            return false;
        }
        if (StringKit.isEmpty(regex)) {
            return true;
        }
        Pattern pattern = org.miaixz.bus.core.center.regex.Pattern.get(regex, 32);
        return PatternKit.isMatch(pattern, content);
    }

    public static boolean isMatch(Pattern pattern, CharSequence content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static String replaceAll(CharSequence content, String regex, String replacementTemplate) {
        Pattern pattern = Pattern.compile(regex, 32);
        return PatternKit.replaceAll(content, pattern, replacementTemplate);
    }

    public static String replaceAll(CharSequence content, Pattern pattern, String replacementTemplate) {
        if (StringKit.isEmpty(content)) {
            return StringKit.toString(content);
        }
        Assert.notNull(replacementTemplate, "ReplacementTemplate must be not null !", new Object[0]);
        Matcher matcher = pattern.matcher(content);
        boolean result = matcher.find();
        if (result) {
            Set varNums = PatternKit.findAll(org.miaixz.bus.core.center.regex.Pattern.GROUP_VAR_PATTERN, (CharSequence)replacementTemplate, 1, new TreeSet(LengthCompare.INSTANCE.reversed()));
            StringBuffer sb = new StringBuffer();
            do {
                String replacement = replacementTemplate;
                for (String var : varNums) {
                    int group = Integer.parseInt(var);
                    replacement = replacement.replace("$" + var, matcher.group(group));
                }
                matcher.appendReplacement(sb, PatternKit.escape(replacement));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return StringKit.toString(content);
    }

    public static String replaceAll(CharSequence text, String regex, FunctionX<Matcher, String> replaceFun) {
        return PatternKit.replaceAll(text, Pattern.compile(regex), replaceFun);
    }

    public static String replaceAll(CharSequence text, Pattern pattern, FunctionX<Matcher, String> replaceFun) {
        if (StringKit.isEmpty(text)) {
            return StringKit.toString(text);
        }
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, replaceFun.apply(matcher));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String escape(char c) {
        StringBuilder builder = new StringBuilder();
        if (RE_KEYS.contains(Character.valueOf(c))) {
            builder.append('\\');
        }
        builder.append(c);
        return builder.toString();
    }

    public static String escape(CharSequence content) {
        if (StringKit.isBlank(content)) {
            return StringKit.toString(content);
        }
        StringBuilder builder = new StringBuilder();
        int len = content.length();
        for (int i = 0; i < len; ++i) {
            char current = content.charAt(i);
            if (RE_KEYS.contains(Character.valueOf(current))) {
                builder.append('\\');
            }
            builder.append(current);
        }
        return builder.toString();
    }

    private static class RegexWithFlag {
        private final String regex;
        private final int flag;

        public RegexWithFlag(String regex, int flag) {
            this.regex = regex;
            this.flag = flag;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.flag;
            result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RegexWithFlag other = (RegexWithFlag)obj;
            if (this.flag != other.flag) {
                return false;
            }
            if (this.regex == null) {
                return other.regex == null;
            }
            return this.regex.equals(other.regex);
        }
    }
}

