/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.beans.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.miaixz.bus.core.beans.PropDesc;
import org.miaixz.bus.core.beans.copier.AbstractCopier;
import org.miaixz.bus.core.beans.copier.CopyOptions;
import org.miaixz.bus.core.beans.copier.ValueProvider;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.mutable.MutableEntry;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class ValueProviderToBeanCopier<T>
extends AbstractCopier<ValueProvider<String>, T> {
    private final Type targetType;

    public ValueProviderToBeanCopier(ValueProvider<String> source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropDesc> targetPropDescMap = BeanKit.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        targetPropDescMap.forEach((tFieldName, tDesc) -> {
            if (null == tFieldName) {
                return;
            }
            if (null == tDesc || !tDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            Type fieldType = TypeKit.getActualType(this.targetType, tDesc.getFieldType());
            MutableEntry<String, Object> entry = this.copyOptions.editField((String)tFieldName, null);
            if (null == entry) {
                return;
            }
            tFieldName = entry.getKey();
            if (null == tFieldName) {
                return;
            }
            if (!((ValueProvider)this.source).containsKey(tFieldName)) {
                return;
            }
            Object sValue = ((ValueProvider)this.source).value(tFieldName, fieldType);
            if (!this.copyOptions.testPropertyFilter(tDesc.getField(), sValue)) {
                return;
            }
            tDesc.setValue(this.target, sValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }
}

