/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.cache.provider;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.miaixz.bus.core.xyz.DateKit;

public class CacheObject<K, V>
implements Serializable {
    private static final long serialVersionUID = -1L;
    protected final K key;
    protected final V obj;
    protected final long ttl;
    protected volatile long lastAccess;
    protected AtomicLong accessCount = new AtomicLong();

    protected CacheObject(K key, V obj, long ttl) {
        this.key = key;
        this.obj = obj;
        this.ttl = ttl;
        this.lastAccess = System.currentTimeMillis();
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.obj;
    }

    public long getTtl() {
        return this.ttl;
    }

    public Date getExpiredTime() {
        if (this.ttl > 0L) {
            return DateKit.date(this.lastAccess + this.ttl);
        }
        return null;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public String toString() {
        return "CacheObject [data=" + String.valueOf(this.key) + ", obj=" + String.valueOf(this.obj) + ", lastAccess=" + this.lastAccess + ", accessCount=" + String.valueOf(this.accessCount) + ", ttl=" + this.ttl + "]";
    }

    protected boolean isExpired() {
        if (this.ttl > 0L) {
            return System.currentTimeMillis() - this.lastAccess > this.ttl;
        }
        return false;
    }

    protected V get(boolean isUpdateLastAccess) {
        if (isUpdateLastAccess) {
            this.lastAccess = System.currentTimeMillis();
        }
        this.accessCount.getAndIncrement();
        return this.obj;
    }
}

