/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date;

import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import org.miaixz.bus.core.center.date.Calendar;
import org.miaixz.bus.core.center.date.Converter;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.center.date.Formatter;
import org.miaixz.bus.core.center.date.format.CustomFormat;
import org.miaixz.bus.core.center.date.format.parser.PositionDateParser;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.StringKit;

public class Resolver
extends Converter {
    public static DateTime parse(CharSequence dateStr, DateFormat dateFormat) {
        return new DateTime(dateStr, dateFormat);
    }

    public static DateTime parse(CharSequence dateStr, PositionDateParser parser) {
        return new DateTime(dateStr, parser);
    }

    public static DateTime parse(CharSequence dateStr, PositionDateParser parser, boolean lenient) {
        return new DateTime(dateStr, parser, lenient);
    }

    public static DateTime parse(CharSequence dateStr, DateTimeFormatter formatter) {
        return new DateTime(dateStr, formatter);
    }

    public static DateTime parse(CharSequence dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime parse(CharSequence dateStr, String format, Locale locale) {
        if (CustomFormat.isCustomFormat(format)) {
            return new DateTime(CustomFormat.parse(dateStr, format));
        }
        return new DateTime(dateStr, Resolver.newSimpleFormat(format, locale, null));
    }

    public static DateTime parse(String text, String ... parsePatterns) throws DateException {
        return Resolver.date(Calendar.parseByPatterns(text, parsePatterns));
    }

    public static LocalDateTime parseTime(CharSequence text, String format) {
        if (StringKit.isBlank((CharSequence)text)) {
            return null;
        }
        if (CustomFormat.isCustomFormat(format)) {
            return Resolver.of(CustomFormat.parse((CharSequence)text, format).toInstant());
        }
        DateTimeFormatter formatter = null;
        if (StringKit.isNotBlank(format)) {
            if (StringKit.startWithIgnoreEquals(format, "yyyyMMddHHmmss") && format.endsWith("S")) {
                int paddingWidth = 3 - (format.length() - "yyyyMMddHHmmss".length());
                if (paddingWidth > 0) {
                    text = String.valueOf(text) + StringKit.repeat('0', paddingWidth);
                }
                formatter = Formatter.PURE_DATETIME_MS_FORMATTER;
            } else {
                formatter = DateTimeFormatter.ofPattern(format);
            }
        }
        return Resolver.parseTime((CharSequence)text, formatter);
    }

    public static LocalDateTime parseTime(CharSequence text, DateTimeFormatter formatter) {
        if (StringKit.isBlank(text)) {
            return null;
        }
        if (null == formatter) {
            return LocalDateTime.parse(text);
        }
        return Resolver.of(formatter.parse(text));
    }

    public static LocalDate parseDate(CharSequence text, String format) {
        if (StringKit.isBlank(text)) {
            return null;
        }
        return Resolver.parseDate(text, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDate parseDate(CharSequence text, DateTimeFormatter formatter) {
        if (StringKit.isBlank(text)) {
            return null;
        }
        if (null == formatter) {
            return LocalDate.parse(text);
        }
        return Resolver.ofDate(formatter.parse(text));
    }

    public static LocalDate parseDateByISO(CharSequence text) {
        return Resolver.parseDate(text, (DateTimeFormatter)null);
    }

    public static LocalDateTime parseTimeByISO(CharSequence text) {
        if (StringKit.contains(text, 'T')) {
            return Resolver.parseTime(text, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        return Resolver.parseTime(text, Formatter.NORM_DATETIME_FORMATTER);
    }

    public static String normalize(CharSequence dateStr) {
        if (StringKit.isBlank(dateStr)) {
            return StringKit.toString(dateStr);
        }
        List<String> dateAndTime = CharsBacker.splitTrim(dateStr, " ");
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return StringKit.toString(dateStr);
        }
        StringBuilder builder = StringKit.builder();
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = StringKit.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = StringKit.removeSuffix(timePart, ":");
            timePart = timePart.replace(',', '.');
            builder.append(timePart);
        }
        return builder.toString();
    }
}

