/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.cn.birth;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.center.date.culture.Tradition;
import org.miaixz.bus.core.center.date.culture.cn.Duty;
import org.miaixz.bus.core.center.date.culture.cn.sixty.EarthBranch;
import org.miaixz.bus.core.center.date.culture.cn.sixty.HeavenStem;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycle;
import org.miaixz.bus.core.center.date.culture.solar.SolarDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarMonth;
import org.miaixz.bus.core.center.date.culture.solar.SolarTerm;
import org.miaixz.bus.core.center.date.culture.solar.SolarTime;

public class EightChar
extends Tradition {
    protected SixtyCycle year;
    protected SixtyCycle month;
    protected SixtyCycle day;
    protected SixtyCycle hour;

    public EightChar(SixtyCycle year, SixtyCycle month, SixtyCycle day, SixtyCycle hour) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
    }

    public EightChar(String year, String month, String day, String hour) {
        this(SixtyCycle.fromName(year), SixtyCycle.fromName(month), SixtyCycle.fromName(day), SixtyCycle.fromName(hour));
    }

    public SixtyCycle getYear() {
        return this.year;
    }

    public SixtyCycle getMonth() {
        return this.month;
    }

    public SixtyCycle getDay() {
        return this.day;
    }

    public SixtyCycle getHour() {
        return this.hour;
    }

    public SixtyCycle getFetalOrigin() {
        return SixtyCycle.fromName(this.month.getHeavenStem().next(1).getName() + this.month.getEarthBranch().next(3).getName());
    }

    public SixtyCycle getFetalBreath() {
        return SixtyCycle.fromName(this.day.getHeavenStem().next(5).getName() + EarthBranch.fromIndex(13 - this.day.getEarthBranch().getIndex()).getName());
    }

    public SixtyCycle getOwnSign() {
        int offset = this.month.getEarthBranch().next(-1).getIndex() + this.hour.getEarthBranch().next(-1).getIndex();
        offset = (offset >= 14 ? 26 : 14) - offset;
        return SixtyCycle.fromName(HeavenStem.fromIndex((this.year.getHeavenStem().getIndex() + 1) * 2 + --offset).getName() + EarthBranch.fromIndex(2 + offset).getName());
    }

    public SixtyCycle getBodySign() {
        int offset = this.month.getEarthBranch().getIndex() + this.hour.getEarthBranch().getIndex();
        offset %= 12;
        return SixtyCycle.fromName(HeavenStem.fromIndex((this.year.getHeavenStem().getIndex() + 1) * 2 + --offset).getName() + EarthBranch.fromIndex(2 + offset).getName());
    }

    public Duty getDuty() {
        return Duty.fromIndex(this.day.getEarthBranch().getIndex() - this.month.getEarthBranch().getIndex());
    }

    public List<SolarTime> getSolarTimes(int startYear, int endYear) {
        ArrayList<SolarTime> l = new ArrayList<SolarTime>();
        int m = this.month.getEarthBranch().next(-2).getIndex();
        if (!HeavenStem.fromIndex((this.year.getHeavenStem().getIndex() + 1) * 2 + m).equals(this.month.getHeavenStem())) {
            return l;
        }
        m *= 2;
        int h = this.hour.getEarthBranch().getIndex() * 2;
        int baseYear = startYear - 1;
        for (int y = this.year.next(-57).getIndex() + 1; y <= endYear; y += 60) {
            SolarTime solarTime;
            if (y < baseYear) continue;
            SolarTerm term = SolarTerm.fromIndex(y, 3);
            if (m > 0) {
                term = term.next(m);
            }
            if ((solarTime = term.getJulianDay().getSolarTime()).getDay().getMonth().getYear().getYear() < startYear) continue;
            int mi = 0;
            int s = 0;
            SolarDay solarDay = solarTime.getDay();
            int d = this.day.next(-solarDay.getLunarDay().getSixtyCycle().getIndex()).getIndex();
            if (d > 0) {
                solarDay = solarDay.next(d);
            } else if (h == solarTime.getHour()) {
                mi = solarTime.getMinute();
                s = solarTime.getSecond();
            }
            SolarMonth solarMonth = solarDay.getMonth();
            SolarTime time = SolarTime.fromYmdHms(solarMonth.getYear().getYear(), solarMonth.getMonth(), solarDay.getDay(), h, mi, s);
            if (!time.getLunarHour().getEightChar().equals(this)) continue;
            l.add(time);
        }
        return l;
    }

    @Override
    public String getName() {
        return String.format("%s %s %s %s", this.year, this.month, this.day, this.hour);
    }
}

