/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.cn.sixty;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.core.center.date.Between;
import org.miaixz.bus.core.center.date.culture.Samsara;
import org.miaixz.bus.core.center.date.culture.cn.Direction;
import org.miaixz.bus.core.center.date.culture.cn.Element;
import org.miaixz.bus.core.center.date.culture.cn.Zodiac;
import org.miaixz.bus.core.center.date.culture.cn.minor.PengZuEarthBranch;
import org.miaixz.bus.core.center.date.culture.cn.sixty.HeavenStem;
import org.miaixz.bus.core.xyz.StringKit;

public class EarthBranch
extends Samsara {
    public static final String[] NAMES = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final Map<String, Integer[]> TIME_MAP = new HashMap<String, Integer[]>();
    private static final Map<Integer, String> HOUR_MAP = new HashMap<Integer, String>();

    public EarthBranch(int index) {
        super(NAMES, index);
    }

    public EarthBranch(String name) {
        super(NAMES, name);
    }

    public static EarthBranch fromIndex(int index) {
        return new EarthBranch(index);
    }

    public static EarthBranch fromName(String name) {
        return new EarthBranch(name);
    }

    public static Between of(String chrono) {
        if (StringKit.isEmpty(chrono)) {
            throw new IllegalArgumentException("Invalid args for : " + chrono);
        }
        String baseTime = chrono.replace("\u65f6", "");
        Integer[] hours = TIME_MAP.get(baseTime);
        if (hours == null) {
            throw new IllegalArgumentException("Invalid time");
        }
        Integer startHour = hours[0];
        Integer endHour = hours[1];
        LocalDateTime start = LocalDateTime.now().withHour(startHour).withMinute(0).withSecond(0).withNano(0);
        LocalDateTime end = startHour > endHour ? start.plusDays(1L).withHour(endHour) : start.withHour(endHour);
        Date startDate = Date.from(start.atZone(ZoneId.systemDefault()).toInstant());
        Date endDate = Date.from(end.atZone(ZoneId.systemDefault()).toInstant());
        return Between.of(startDate, endDate);
    }

    public static String get(int hour) {
        return HOUR_MAP.getOrDefault(hour, "\u672a\u77e5");
    }

    @Override
    public EarthBranch next(int n) {
        return EarthBranch.fromIndex(this.nextIndex(n));
    }

    public Element getElement() {
        return Element.fromIndex((new int[]{4, 2, 0, 0, 2, 1, 1, 2, 3, 3, 2, 4})[this.index]);
    }

    public HeavenStem getHideHeavenStemMain() {
        return HeavenStem.fromIndex((new int[]{9, 5, 0, 1, 4, 2, 3, 5, 6, 7, 4, 8})[this.index]);
    }

    public HeavenStem getHideHeavenStemMiddle() {
        int n = (new int[]{-1, 9, 2, -1, 1, 6, 5, 3, 8, -1, 7, 0})[this.index];
        return n == -1 ? null : HeavenStem.fromIndex(n);
    }

    public HeavenStem getHideHeavenStemResidual() {
        int n = (new int[]{-1, 7, 4, -1, 9, 4, -1, 1, 4, -1, 3, -1})[this.index];
        return n == -1 ? null : HeavenStem.fromIndex(n);
    }

    public Zodiac getZodiac() {
        return Zodiac.fromIndex(this.index);
    }

    public Direction getDirection() {
        return Direction.fromIndex((new int[]{0, 4, 2, 2, 4, 8, 8, 4, 6, 6, 4, 0})[this.index]);
    }

    public EarthBranch next() {
        return this.next(6);
    }

    public Direction getOminous() {
        return Direction.fromIndex((new int[]{8, 2, 0, 6})[this.index % 4]);
    }

    public PengZuEarthBranch getPengZuEarthBranch() {
        return PengZuEarthBranch.fromIndex(this.index);
    }

    static {
        int hour = 23;
        for (String c : NAMES) {
            TIME_MAP.put(c, new Integer[]{hour % 24, (hour + 2) % 24});
            HOUR_MAP.put(hour % 24, c + "\u65f6");
            HOUR_MAP.put((hour + 1) % 24, c + "\u65f6");
            hour += 2;
        }
    }
}

