/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.solar;

import org.miaixz.bus.core.center.date.culture.Holiday;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.JulianDay;
import org.miaixz.bus.core.center.date.culture.cn.Week;
import org.miaixz.bus.core.center.date.culture.cn.climate.Climate;
import org.miaixz.bus.core.center.date.culture.cn.climate.ClimateDay;
import org.miaixz.bus.core.center.date.culture.cn.dog.Dog;
import org.miaixz.bus.core.center.date.culture.cn.dog.DogDay;
import org.miaixz.bus.core.center.date.culture.cn.nine.Nine;
import org.miaixz.bus.core.center.date.culture.cn.nine.NineDay;
import org.miaixz.bus.core.center.date.culture.en.Constellation;
import org.miaixz.bus.core.center.date.culture.lunar.LunarDay;
import org.miaixz.bus.core.center.date.culture.lunar.LunarMonth;
import org.miaixz.bus.core.center.date.culture.solar.SolarFestival;
import org.miaixz.bus.core.center.date.culture.solar.SolarMonth;
import org.miaixz.bus.core.center.date.culture.solar.SolarTerm;
import org.miaixz.bus.core.center.date.culture.solar.SolarWeek;

public class SolarDay
extends Loops {
    public static final String[] NAMES = new String[]{"1\u65e5", "2\u65e5", "3\u65e5", "4\u65e5", "5\u65e5", "6\u65e5", "7\u65e5", "8\u65e5", "9\u65e5", "10\u65e5", "11\u65e5", "12\u65e5", "13\u65e5", "14\u65e5", "15\u65e5", "16\u65e5", "17\u65e5", "18\u65e5", "19\u65e5", "20\u65e5", "21\u65e5", "22\u65e5", "23\u65e5", "24\u65e5", "25\u65e5", "26\u65e5", "27\u65e5", "28\u65e5", "29\u65e5", "30\u65e5", "31\u65e5"};
    protected SolarMonth month;
    protected int day;

    public SolarDay(int year, int month, int day) {
        if (day < 1) {
            throw new IllegalArgumentException(String.format("illegal solar day: %d-%d-%d", year, month, day));
        }
        SolarMonth m = SolarMonth.fromYm(year, month);
        if (1582 == year && 10 == month ? day > 4 && day < 15 || day > 31 : day > m.getDayCount()) {
            throw new IllegalArgumentException(String.format("illegal solar day: %d-%d-%d", year, month, day));
        }
        this.month = m;
        this.day = day;
    }

    public static SolarDay fromYmd(int year, int month, int day) {
        return new SolarDay(year, month, day);
    }

    public SolarMonth getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public Week getWeek() {
        return this.getJulianDay().getWeek();
    }

    public Constellation getConstellation() {
        int index = 11;
        int y = this.month.getMonth() * 100 + this.day;
        if (y >= 321 && y <= 419) {
            index = 0;
        } else if (y >= 420 && y <= 520) {
            index = 1;
        } else if (y >= 521 && y <= 621) {
            index = 2;
        } else if (y >= 622 && y <= 722) {
            index = 3;
        } else if (y >= 723 && y <= 822) {
            index = 4;
        } else if (y >= 823 && y <= 922) {
            index = 5;
        } else if (y >= 923 && y <= 1023) {
            index = 6;
        } else if (y >= 1024 && y <= 1122) {
            index = 7;
        } else if (y >= 1123 && y <= 1221) {
            index = 8;
        } else if (y >= 1222 || y <= 119) {
            index = 9;
        } else if (y <= 218) {
            index = 10;
        }
        return Constellation.get(index);
    }

    @Override
    public String getName() {
        return NAMES[this.day - 1];
    }

    @Override
    public String toString() {
        return String.valueOf(this.month) + this.getName();
    }

    @Override
    public SolarDay next(int n) {
        return this.getJulianDay().next(n).getSolarDay();
    }

    public boolean isBefore(SolarDay target) {
        SolarMonth targetMonth;
        int bYear;
        int aYear = this.month.getYear().getYear();
        if (aYear == (bYear = (targetMonth = target.getMonth()).getYear().getYear())) {
            int bMonth;
            int aMonth = this.month.getMonth();
            return aMonth == (bMonth = targetMonth.getMonth()) ? this.day < target.getDay() : aMonth < bMonth;
        }
        return aYear < bYear;
    }

    public boolean isAfter(SolarDay target) {
        SolarMonth targetMonth;
        int bYear;
        int aYear = this.month.getYear().getYear();
        if (aYear == (bYear = (targetMonth = target.getMonth()).getYear().getYear())) {
            int bMonth;
            int aMonth = this.month.getMonth();
            return aMonth == (bMonth = targetMonth.getMonth()) ? this.day > target.getDay() : aMonth > bMonth;
        }
        return aYear > bYear;
    }

    public SolarTerm getTerm() {
        SolarTerm term = SolarTerm.fromIndex(this.month.getYear().getYear() + 1, 0);
        while (this.isBefore(term.getJulianDay().getSolarDay())) {
            term = term.next(-1);
        }
        return term;
    }

    public SolarWeek getSolarWeek(int start) {
        int y = this.month.getYear().getYear();
        int m = this.month.getMonth();
        return SolarWeek.fromYm(y, m, (int)Math.ceil((double)(this.day + SolarDay.fromYmd(y, m, 1).getWeek().next(-start).getIndex()) / 7.0) - 1, start);
    }

    public ClimateDay getPhenologyDay() {
        SolarTerm term = this.getTerm();
        int dayIndex = this.subtract(term.getJulianDay().getSolarDay());
        int index = dayIndex / 5;
        if (index > 2) {
            index = 2;
        }
        return new ClimateDay(Climate.fromIndex(term.getIndex() * 3 + index), dayIndex -= index * 5);
    }

    public DogDay getDogDay() {
        int days;
        SolarTerm xiaZhi = SolarTerm.fromIndex(this.month.getYear().getYear(), 12);
        SolarDay start = xiaZhi.getJulianDay().getSolarDay();
        int add = 6 - start.getLunarDay().getSixtyCycle().getHeavenStem().getIndex();
        if (add < 0) {
            add += 10;
        }
        if ((days = this.subtract(start = start.next(add += 20))) < 0) {
            return null;
        }
        if (days < 10) {
            return new DogDay(Dog.fromIndex(0), days);
        }
        days = this.subtract(start = start.next(10));
        if (days < 10) {
            return new DogDay(Dog.fromIndex(1), days);
        }
        start = start.next(10);
        days = this.subtract(start);
        if (xiaZhi.next(3).getJulianDay().getSolarDay().isAfter(start)) {
            if (days < 10) {
                return new DogDay(Dog.fromIndex(1), days + 10);
            }
            start = start.next(10);
            days = this.subtract(start);
        }
        if (days < 10) {
            return new DogDay(Dog.fromIndex(2), days);
        }
        return null;
    }

    public NineDay getNineDay() {
        int year = this.month.getYear().getYear();
        SolarDay start = SolarTerm.fromIndex(year + 1, 0).getJulianDay().getSolarDay();
        if (this.isBefore(start)) {
            start = SolarTerm.fromIndex(year, 0).getJulianDay().getSolarDay();
        }
        SolarDay end = start.next(81);
        if (this.isBefore(start) || !this.isBefore(end)) {
            return null;
        }
        int days = this.subtract(start);
        return new NineDay(Nine.fromIndex(days / 9), days % 9);
    }

    public int getIndexInYear() {
        int m = this.month.getMonth();
        int y = this.month.getYear().getYear();
        int days = 0;
        for (int i = 1; i < m; ++i) {
            days += SolarMonth.fromYm(y, i).getDayCount();
        }
        int d = this.day;
        if (1582 == y && 10 == m && d >= 15) {
            d -= 10;
        }
        return days + d - 1;
    }

    public int subtract(SolarDay target) {
        return (int)(this.getJulianDay().getDay() - target.getJulianDay().getDay());
    }

    public JulianDay getJulianDay() {
        return JulianDay.fromYmdHms(this.month.getYear().getYear(), this.month.getMonth(), this.day, 0, 0, 0);
    }

    public LunarDay getLunarDay() {
        LunarMonth m = LunarMonth.fromYm(this.month.getYear().getYear(), this.month.getMonth()).next(-3);
        int days = this.subtract(m.getFirstJulianDay().getSolarDay());
        while (days >= m.getDayCount()) {
            m = m.next(1);
            days = this.subtract(m.getFirstJulianDay().getSolarDay());
        }
        return LunarDay.fromYmd(m.getYear().getYear(), m.getMonthWithLeap(), days + 1);
    }

    public Holiday getLegalHoliday() {
        SolarMonth m = this.getMonth();
        return Holiday.fromYmd(m.getYear().getYear(), m.getMonth(), this.day);
    }

    public SolarFestival getFestival() {
        SolarMonth m = this.getMonth();
        return SolarFestival.fromYmd(m.getYear().getYear(), m.getMonth(), this.day);
    }
}

