/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.solar;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.solar.SolarDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarMonth;
import org.miaixz.bus.core.lang.EnumMap;

public class SolarFestival
extends Loops {
    public static final String[] NAMES = new String[]{"\u5143\u65e6", "\u4e09\u516b\u5987\u5973\u8282", "\u690d\u6811\u8282", "\u4e94\u4e00\u52b3\u52a8\u8282", "\u4e94\u56db\u9752\u5e74\u8282", "\u516d\u4e00\u513f\u7ae5\u8282", "\u5efa\u515a\u8282", "\u516b\u4e00\u5efa\u519b\u8282", "\u6559\u5e08\u8282", "\u56fd\u5e86\u8282"};
    public static String DATA = "@00001011950@01003081950@02003121979@03005011950@04005041950@05006011950@06007011941@07008011933@08009101985@09010011950";
    protected EnumMap.Festival type;
    protected int index;
    protected SolarDay day;
    protected String name;
    protected int startYear;

    public SolarFestival(EnumMap.Festival type, SolarDay day, int startYear, String data) {
        this.type = type;
        this.day = day;
        this.startYear = startYear;
        this.index = Integer.parseInt(data.substring(1, 3), 10);
        this.name = NAMES[this.index];
    }

    public static SolarFestival fromIndex(int year, int index) {
        int startYear;
        String data;
        EnumMap.Festival type;
        if (index < 0 || index >= NAMES.length) {
            throw new IllegalArgumentException(String.format("illegal index: %d", index));
        }
        Matcher matcher = Pattern.compile(String.format("@%02d\\d+", index)).matcher(DATA);
        if (matcher.find() && (type = EnumMap.Festival.fromCode((data = matcher.group()).charAt(3) - 48)) == EnumMap.Festival.DAY && year >= (startYear = Integer.parseInt(data.substring(8), 10))) {
            return new SolarFestival(type, SolarDay.fromYmd(year, Integer.parseInt(data.substring(4, 6), 10), Integer.parseInt(data.substring(6, 8), 10)), startYear, data);
        }
        return null;
    }

    public static SolarFestival fromYmd(int year, int month, int day) {
        String data;
        int startYear;
        Matcher matcher = Pattern.compile(String.format("@\\d{2}0%02d%02d\\d+", month, day)).matcher(DATA);
        if (matcher.find() && year >= (startYear = Integer.parseInt((data = matcher.group()).substring(8), 10))) {
            return new SolarFestival(EnumMap.Festival.DAY, SolarDay.fromYmd(year, month, day), startYear, data);
        }
        return null;
    }

    @Override
    public SolarFestival next(int n) {
        SolarMonth m = this.day.getMonth();
        int year = m.getYear().getYear();
        if (n == 0) {
            return SolarFestival.fromYmd(year, m.getMonth(), this.day.getDay());
        }
        int size = NAMES.length;
        int t = this.index + n;
        int offset = this.indexOf(t, size);
        if (t < 0) {
            t -= size;
        }
        return SolarFestival.fromIndex(year + t / size, offset);
    }

    public EnumMap.Festival getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public SolarDay getDay() {
        return this.day;
    }

    public int getStartYear() {
        return this.startYear;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return String.format("%s %s", this.day, this.name);
    }
}

