/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.format.parser;

import java.util.Locale;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.center.date.Formatter;
import org.miaixz.bus.core.center.date.format.FormatBuilder;
import org.miaixz.bus.core.center.date.format.parser.PredicateDateParser;
import org.miaixz.bus.core.center.date.printer.DefaultDatePrinter;
import org.miaixz.bus.core.xyz.StringKit;

public class RFC2822DateParser
extends DefaultDatePrinter
implements PredicateDateParser {
    private static final long serialVersionUID = -1L;
    private static final String KEYWORDS_LOCALE_CHINA = "\u661f\u671f";
    private static final String[] wtb = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    public static RFC2822DateParser INSTANCE = new RFC2822DateParser();

    @Override
    public boolean test(CharSequence dateStr) {
        return StringKit.containsAnyIgnoreCase(dateStr, wtb);
    }

    @Override
    public DateTime parse(String source) {
        if (StringKit.contains((CharSequence)source, ',')) {
            if (StringKit.contains((CharSequence)source, KEYWORDS_LOCALE_CHINA)) {
                return new DateTime((CharSequence)source, FormatBuilder.getInstance("EEE, dd MMM yyyy HH:mm:ss z", Locale.CHINA));
            }
            return new DateTime((CharSequence)source, Formatter.HTTP_DATETIME_FORMAT);
        }
        if (StringKit.contains((CharSequence)source, KEYWORDS_LOCALE_CHINA)) {
            return new DateTime((CharSequence)source, FormatBuilder.getInstance("EEE MMM dd HH:mm:ss zzz yyyy", Locale.CHINA));
        }
        return new DateTime((CharSequence)source, Formatter.JDK_DATETIME_FORMAT);
    }
}

