/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.miaixz.bus.core.xyz.ExceptionKit;

@FunctionalInterface
public interface PredicateX<T>
extends Predicate<T>,
Serializable {
    @SafeVarargs
    public static <T> PredicateX<T> multiAnd(PredicateX<T> ... predicates) {
        return Stream.of(predicates).reduce(PredicateX::and).orElseGet(() -> o -> true);
    }

    @SafeVarargs
    public static <T> PredicateX<T> multiOr(PredicateX<T> ... predicates) {
        return Stream.of(predicates).reduce(PredicateX::or).orElseGet(() -> o -> false);
    }

    public static <T> PredicateX<T> isEqual(Object ... targetRef) {
        return null == targetRef ? Objects::isNull : object -> Stream.of(targetRef).allMatch(target -> target.equals(object));
    }

    public boolean testing(T var1) throws Throwable;

    @Override
    default public boolean test(T t) {
        try {
            return this.testing(t);
        }
        catch (Throwable e) {
            throw ExceptionKit.wrapRuntime(e);
        }
    }

    @Override
    default public PredicateX<T> and(PredicateX<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    @Override
    default public PredicateX<T> negate() {
        return t -> !this.test(t);
    }

    @Override
    default public PredicateX<T> or(PredicateX<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }
}

