/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.util.HashMap;
import java.util.Set;
import org.miaixz.bus.core.center.map.BiMap;

public enum BasicType {
    BYTE,
    SHORT,
    INT,
    INTEGER,
    LONG,
    DOUBLE,
    FLOAT,
    BOOLEAN,
    CHAR,
    CHARACTER,
    STRING;

    private static final BiMap<Class<?>, Class<?>> WRAPPER_PRIMITIVE_MAP;

    public static Class<?> wrap(Class<?> clazz) {
        return BasicType.wrap(clazz, false);
    }

    public static Class<?> wrap(Class<?> clazz, boolean errorReturnNull) {
        if (null == clazz || !clazz.isPrimitive()) {
            return clazz;
        }
        Class<?> result = WRAPPER_PRIMITIVE_MAP.getInverse().get(clazz);
        return null == result ? (errorReturnNull ? null : clazz) : result;
    }

    public static Class<?> unWrap(Class<?> clazz) {
        if (null == clazz || clazz.isPrimitive()) {
            return clazz;
        }
        Class result = (Class)WRAPPER_PRIMITIVE_MAP.get(clazz);
        return null == result ? clazz : result;
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return WRAPPER_PRIMITIVE_MAP.containsKey(clazz);
    }

    public static Set<Class<?>> getPrimitiveSet() {
        return WRAPPER_PRIMITIVE_MAP.getInverse().keySet();
    }

    public static Set<Class<?>> getWrapperSet() {
        return WRAPPER_PRIMITIVE_MAP.keySet();
    }

    static {
        WRAPPER_PRIMITIVE_MAP = new BiMap(new HashMap(8, 1.0f));
        WRAPPER_PRIMITIVE_MAP.put(Boolean.class, Boolean.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Byte.class, Byte.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Character.class, Character.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Double.class, Double.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Float.class, Float.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Integer.class, Integer.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Long.class, Long.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Short.class, Short.TYPE);
    }
}

