/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.miaixz.bus.core.lang.Keys;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.StringKit;

public class FileName {
    public static final String EXT_JAVA = ".java";
    public static final String EXT_CLASS = ".class";
    public static final String EXT_JAR = ".jar";
    public static final String EXT_JAR_PATH = ".jar!";
    public static final char UNIX_SEPARATOR = '/';
    public static final char WINDOWS_SEPARATOR = '\\';
    private static final Pattern FILE_NAME_INVALID_PATTERN_WIN = Pattern.compile("[\\\\/:*?\"<>|\r\n]");
    private static final CharSequence[] SPECIAL_SUFFIX = new CharSequence[]{"tar.bz2", "tar.Z", "tar.gz", "tar.xz"};

    public static String getName(File file) {
        return null != file ? file.getName() : null;
    }

    public static String getName(String filePath) {
        if (null == filePath) {
            return null;
        }
        int len = filePath.length();
        if (0 == len) {
            return filePath;
        }
        if (CharKit.isFileSeparator(filePath.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        for (int i = len - 1; i > -1; --i) {
            char c = filePath.charAt(i);
            if (!CharKit.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return filePath.substring(begin, len);
    }

    public static String mainName(File file) {
        if (file.isDirectory()) {
            return file.getName();
        }
        return FileName.mainName(file.getName());
    }

    public static String mainName(String fileName) {
        if (null == fileName) {
            return null;
        }
        int len = fileName.length();
        if (0 == len) {
            return fileName;
        }
        for (CharSequence specialSuffix : SPECIAL_SUFFIX) {
            if (!StringKit.endWith((CharSequence)fileName, "." + String.valueOf(specialSuffix))) continue;
            return StringKit.subPre(fileName, len - specialSuffix.length() - 1);
        }
        if (CharKit.isFileSeparator(fileName.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        int end = len;
        for (int i = len - 1; i >= 0; --i) {
            char c = fileName.charAt(i);
            if (len == end && '.' == c) {
                end = i;
            }
            if (!CharKit.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return fileName.substring(begin, end);
    }

    public static String extName(File file) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return FileName.extName(file.getName());
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        int secondToLastIndex = fileName.substring(0, index).lastIndexOf(".");
        String substr = fileName.substring(secondToLastIndex == -1 ? index : secondToLastIndex + 1);
        if (StringKit.containsAny((CharSequence)substr, SPECIAL_SUFFIX)) {
            return substr;
        }
        String ext = fileName.substring(index + 1);
        return StringKit.containsAny((CharSequence)ext, '/', '\\') ? "" : ext;
    }

    public static String getSuffix(File file) {
        return FileName.extName(file);
    }

    public static String getSuffix(String fileName) {
        return FileName.extName(fileName);
    }

    public static String getPrefix(File file) {
        return FileName.mainName(file);
    }

    public static String getPrefix(String fileName) {
        return FileName.mainName(fileName);
    }

    public static String addTempSuffix(String fileName, String suffix) {
        suffix = StringKit.isBlank(suffix) ? ".temp" : StringKit.addPrefixIfNot(suffix, ".");
        return fileName + suffix;
    }

    public static String cleanInvalid(String fileName) {
        return StringKit.isBlank(fileName) ? fileName : PatternKit.delAll(FILE_NAME_INVALID_PATTERN_WIN, (CharSequence)fileName);
    }

    public static boolean containsInvalid(String fileName) {
        return !StringKit.isBlank(fileName) && PatternKit.contains(FILE_NAME_INVALID_PATTERN_WIN, (CharSequence)fileName);
    }

    public static boolean isType(String fileName, String ... extNames) {
        return StringKit.equalsAnyIgnoreCase(FileName.extName(fileName), extNames);
    }

    public static String normalize(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("\\\\")) {
            return path;
        }
        Object pathToUse = StringKit.removePrefixIgnoreCase(path, "classpath:");
        if (StringKit.startWith((CharSequence)(pathToUse = StringKit.removePrefixIgnoreCase((CharSequence)pathToUse, "file:")), '~')) {
            pathToUse = Keys.getUserHomePath() + ((String)pathToUse).substring(1);
        }
        pathToUse = ((String)pathToUse).replaceAll("[/\\\\]+", "/");
        pathToUse = StringKit.trimPrefix((CharSequence)pathToUse);
        Object prefix = "";
        int prefixIndex = ((String)pathToUse).indexOf(":");
        if (prefixIndex > -1) {
            prefix = ((String)pathToUse).substring(0, prefixIndex + 1);
            if (StringKit.startWith((CharSequence)prefix, '/')) {
                prefix = ((String)prefix).substring(1);
            }
            if (!((String)prefix).contains("/")) {
                pathToUse = ((String)pathToUse).substring(prefixIndex + 1);
            } else {
                prefix = "";
            }
        }
        if (((String)pathToUse).startsWith("/")) {
            prefix = (String)prefix + "/";
            pathToUse = ((String)pathToUse).substring(1);
        }
        List<String> pathList = CharsBacker.split((CharSequence)pathToUse, "/");
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (int i = pathList.size() - 1; i >= 0; --i) {
            String element = pathList.get(i);
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        if (tops > 0 && StringKit.isEmpty((CharSequence)prefix)) {
            while (tops-- > 0) {
                pathElements.add(0, "..");
            }
        }
        return (String)prefix + CollKit.join(pathElements, "/");
    }
}

