/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.miaixz.bus.core.io.file.PathResolve;
import org.miaixz.bus.core.io.file.visitor.CopyVisitor;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.copier.SrcToDestCopier;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ObjectKit;

public class PathCopier
extends SrcToDestCopier<Path, PathCopier> {
    private static final long serialVersionUID = -1L;
    private final CopyOption[] options;

    public PathCopier(Path src, Path target, CopyOption[] options) {
        Assert.notNull(target, "Src path must be not null !", new Object[0]);
        if (!PathResolve.exists(src, false)) {
            throw new IllegalArgumentException("Src path is not exist!");
        }
        this.src = src;
        this.target = Assert.notNull(target, "Target path must be not null !", new Object[0]);
        this.options = ObjectKit.defaultIfNull(options, new CopyOption[0]);
    }

    public static PathCopier of(Path src, Path target, boolean isOverride) {
        CopyOption[] copyOptionArray;
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        return PathCopier.of(src, target, copyOptionArray);
    }

    public static PathCopier of(Path src, Path target, CopyOption[] options) {
        return new PathCopier(src, target, options);
    }

    private static Path copyContent(Path src, Path target, CopyOption ... options) throws InternalException {
        try {
            Files.walkFileTree(src, new CopyVisitor(src, target, options));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return target;
    }

    private static Path copyFile(Path src, Path target, CopyOption ... options) throws InternalException {
        Assert.notNull(src, "Source file is null !", new Object[0]);
        Assert.notNull(target, "Target file or directory is null !", new Object[0]);
        Path targetPath = PathResolve.isDirectory(target) ? target.resolve(src.getFileName()) : target;
        PathResolve.mkParentDirs(targetPath);
        try {
            return Files.copy(src, targetPath, options);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public Path copy() throws InternalException {
        if (PathResolve.isDirectory((Path)this.src)) {
            if (PathResolve.exists((Path)this.target, false)) {
                if (PathResolve.isDirectory((Path)this.target)) {
                    return PathCopier.copyContent((Path)this.src, ((Path)this.target).resolve(((Path)this.src).getFileName()), this.options);
                }
                throw new IllegalArgumentException("Can not copier directory to a file!");
            }
            return PathCopier.copyContent((Path)this.src, (Path)this.target, this.options);
        }
        return PathCopier.copyFile((Path)this.src, (Path)this.target, this.options);
    }

    public Path copyContent() throws InternalException {
        if (PathResolve.isDirectory((Path)this.src, false)) {
            return PathCopier.copyContent((Path)this.src, (Path)this.target, this.options);
        }
        return PathCopier.copyFile((Path)this.src, (Path)this.target, this.options);
    }
}

