/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.resource;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.MethodKit;

public class VfsResource
implements Resource {
    private static final String VFS3_PKG = "org.jboss.vfs.";
    private static final Method VIRTUAL_FILE_METHOD_EXISTS;
    private static final Method VIRTUAL_FILE_METHOD_GET_INPUT_STREAM;
    private static final Method VIRTUAL_FILE_METHOD_GET_SIZE;
    private static final Method VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED;
    private static final Method VIRTUAL_FILE_METHOD_TO_URL;
    private static final Method VIRTUAL_FILE_METHOD_GET_NAME;
    private static final Method VIRTUAL_FILE_METHOD_GET_PHYSICAL_FILE;
    private final Object virtualFile;
    private final long lastModified;

    public VfsResource(Object resource) {
        Assert.notNull(resource, "VirtualFile must not be null", new Object[0]);
        this.virtualFile = resource;
        this.lastModified = this.getLastModified();
    }

    public boolean exists() {
        return (Boolean)MethodKit.invoke(this.virtualFile, VIRTUAL_FILE_METHOD_EXISTS, new Object[0]);
    }

    @Override
    public String getName() {
        return (String)MethodKit.invoke(this.virtualFile, VIRTUAL_FILE_METHOD_GET_NAME, new Object[0]);
    }

    @Override
    public URL getUrl() {
        return (URL)MethodKit.invoke(this.virtualFile, VIRTUAL_FILE_METHOD_TO_URL, new Object[0]);
    }

    @Override
    public InputStream getStream() {
        return (InputStream)MethodKit.invoke(this.virtualFile, VIRTUAL_FILE_METHOD_GET_INPUT_STREAM, new Object[0]);
    }

    @Override
    public boolean isModified() {
        return this.lastModified != this.getLastModified();
    }

    public long getLastModified() {
        return (Long)MethodKit.invoke(this.virtualFile, VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED, new Object[0]);
    }

    @Override
    public long size() {
        return (Long)MethodKit.invoke(this.virtualFile, VIRTUAL_FILE_METHOD_GET_SIZE, new Object[0]);
    }

    public File getFile() {
        return (File)MethodKit.invoke(this.virtualFile, VIRTUAL_FILE_METHOD_GET_PHYSICAL_FILE, new Object[0]);
    }

    static {
        Class virtualFile = ClassKit.loadClass("org.jboss.vfs.VirtualFile");
        try {
            VIRTUAL_FILE_METHOD_EXISTS = virtualFile.getMethod("exists", new Class[0]);
            VIRTUAL_FILE_METHOD_GET_INPUT_STREAM = virtualFile.getMethod("openStream", new Class[0]);
            VIRTUAL_FILE_METHOD_GET_SIZE = virtualFile.getMethod("getSize", new Class[0]);
            VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED = virtualFile.getMethod("getLastModified", new Class[0]);
            VIRTUAL_FILE_METHOD_TO_URL = virtualFile.getMethod("toURL", new Class[0]);
            VIRTUAL_FILE_METHOD_GET_NAME = virtualFile.getMethod("getName", new Class[0]);
            VIRTUAL_FILE_METHOD_GET_PHYSICAL_FILE = virtualFile.getMethod("getPhysicalFile", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Could not detect JBoss VFS infrastructure", ex);
        }
    }
}

