/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.sink;

import java.io.IOException;
import java.util.zip.Deflater;
import org.miaixz.bus.core.io.LifeCycle;
import org.miaixz.bus.core.io.SectionBuffer;
import org.miaixz.bus.core.io.buffer.Buffer;
import org.miaixz.bus.core.io.sink.BufferSink;
import org.miaixz.bus.core.io.sink.Sink;
import org.miaixz.bus.core.io.timout.Timeout;
import org.miaixz.bus.core.xyz.IoKit;

public class DeflaterSink
implements Sink {
    private final BufferSink sink;
    private final Deflater deflater;
    private boolean closed;

    public DeflaterSink(Sink sink, Deflater deflater) {
        this(IoKit.buffer(sink), deflater);
    }

    DeflaterSink(BufferSink sink, Deflater deflater) {
        if (sink == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (deflater == null) {
            throw new IllegalArgumentException("inflater == null");
        }
        this.sink = sink;
        this.deflater = deflater;
    }

    @Override
    public void write(Buffer source, long byteCount) throws IOException {
        IoKit.checkOffsetAndCount(source.size, 0L, byteCount);
        while (byteCount > 0L) {
            SectionBuffer head = source.head;
            int toDeflate = (int)Math.min(byteCount, (long)(head.limit - head.pos));
            this.deflater.setInput(head.data, head.pos, toDeflate);
            this.deflate(false);
            source.size -= (long)toDeflate;
            head.pos += toDeflate;
            if (head.pos == head.limit) {
                source.head = head.pop();
                LifeCycle.recycle(head);
            }
            byteCount -= (long)toDeflate;
        }
    }

    private void deflate(boolean syncFlush) throws IOException {
        SectionBuffer s;
        Buffer buffer = this.sink.buffer();
        while (true) {
            int deflated;
            s = buffer.writableSegment(1);
            int n = deflated = syncFlush ? this.deflater.deflate(s.data, s.limit, 8192 - s.limit, 2) : this.deflater.deflate(s.data, s.limit, 8192 - s.limit);
            if (deflated > 0) {
                s.limit += deflated;
                buffer.size += (long)deflated;
                this.sink.emitCompleteSegments();
                continue;
            }
            if (this.deflater.needsInput()) break;
        }
        if (s.pos == s.limit) {
            buffer.head = s.pop();
            LifeCycle.recycle(s);
        }
    }

    @Override
    public void flush() throws IOException {
        this.deflate(true);
        this.sink.flush();
    }

    void finishDeflate() throws IOException {
        this.deflater.finish();
        this.deflate(false);
    }

    @Override
    public void close() throws IOException {
        Throwable thrown;
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                thrown = null;
                try {
                    this.finishDeflate();
                }
                catch (Throwable e) {
                    thrown = e;
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable e) {
                    if (thrown != null) break block8;
                    thrown = e;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable e) {
                if (thrown != null) break block9;
                thrown = e;
            }
        }
        this.closed = true;
        if (thrown != null) {
            IoKit.sneakyRethrow(thrown);
        }
    }

    @Override
    public Timeout timeout() {
        return this.sink.timeout();
    }

    public String toString() {
        return "DeflaterSink(" + String.valueOf(this.sink) + ")";
    }
}

