/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang;

import java.util.Arrays;

public enum Gender {
    MALE(1, "M", "\u7537"),
    FEMALE(0, "F", "\u5973"),
    UNKNOWN(-1, "U", "\u672a\u77e5");

    private final int key;
    private final String code;
    private final String desc;

    public static Gender of(String code) {
        if (null == code) {
            return UNKNOWN;
        }
        String[] males = new String[]{"M", "\u7537", "1", "MALE"};
        if (Arrays.asList(males).contains(code.toUpperCase())) {
            return MALE;
        }
        String[] females = new String[]{"F", "\u5973", "0", "FEMALE"};
        if (Arrays.asList(females).contains(code.toUpperCase())) {
            return FEMALE;
        }
        return UNKNOWN;
    }

    public int getKey() {
        return this.key;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private Gender(int key, String code, String desc) {
        this.key = key;
        this.code = code;
        this.desc = desc;
    }
}

