/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.net.ip;

import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashSet;
import org.miaixz.bus.core.instance.Instances;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.net.ip.IPv4;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.NetKit;

public class IPv6 {
    private static volatile String localhostName;

    public static BigInteger ipv6ToBigInteger(String ipv6Str) {
        try {
            InetAddress address = InetAddress.getByName(ipv6Str);
            if (address instanceof Inet6Address) {
                return new BigInteger(1, address.getAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public static String bigIntegerToIPv6(BigInteger bigInteger) {
        try {
            return InetAddress.getByAddress(bigInteger.toByteArray()).toString().substring(1);
        }
        catch (UnknownHostException ignore) {
            return null;
        }
    }

    public static LinkedHashSet<String> localIps() {
        LinkedHashSet<InetAddress> localAddressList = NetKit.localAddressList(t -> t instanceof Inet6Address);
        return NetKit.toIpList(localAddressList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLocalHostName() {
        if (null != localhostName) return localhostName;
        Class<IPv4> clazz = IPv4.class;
        synchronized (IPv4.class) {
            if (null != localhostName) return localhostName;
            localhostName = NetKit.getAddressName(IPv6.getLocalhostDirectly());
            // ** MonitorExit[var0] (shouldn't be in output)
            return localhostName;
        }
    }

    public static String getLocalMacAddress() {
        return NetKit.getMacAddress(IPv6.getLocalhost());
    }

    public static byte[] getLocalHardwareAddress() {
        return NetKit.getHardwareAddress(IPv6.getLocalhost());
    }

    public static InetAddress getLocalhost() {
        return Instances.get(IPv6.class.getName(), IPv6::getLocalhostDirectly);
    }

    public static InetAddress getLocalhostDirectly() {
        LinkedHashSet<InetAddress> localAddressList = NetKit.localAddressList(address -> address instanceof Inet6Address && !address.isLoopbackAddress() && !address.isSiteLocalAddress() && !address.isLinkLocalAddress());
        if (CollKit.isNotEmpty(localAddressList)) {
            return CollKit.getFirst(localAddressList);
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (localHost instanceof Inet6Address) {
                return localHost;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int index = addr.lastIndexOf(37);
        if (index > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, index) + "%" + address.getScopeId());
            }
            catch (UnknownHostException e) {
                throw new InternalException(e);
            }
        }
        return address;
    }
}

