/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.net.url;

import java.nio.charset.Charset;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.net.url.RFC3986;
import org.miaixz.bus.core.xyz.CharKit;

public class UrlEncoder {
    private static final Charset DEFAULT_CHARSET = org.miaixz.bus.core.lang.Charset.UTF_8;

    public static String encodeAll(String url) {
        return UrlEncoder.encodeAll(url, DEFAULT_CHARSET);
    }

    public static String encodeAll(String url, Charset charset) throws InternalException {
        return RFC3986.UNRESERVED.encode(url, charset, new char[0]);
    }

    public static String encodeQuery(String url) {
        return UrlEncoder.encodeQuery(url, DEFAULT_CHARSET);
    }

    public static String encodeQuery(String url, Charset charset) {
        return RFC3986.QUERY.encode(url, charset, new char[0]);
    }

    public static String encodeBlank(CharSequence urlStr) {
        if (urlStr == null) {
            return null;
        }
        int len = urlStr.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = urlStr.charAt(i);
            if (CharKit.isBlankChar(c)) {
                sb.append("%20");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

