/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.miaixz.bus.core.center.iterator.ArrayIterator;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.IteratorKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class StringJoiner
implements Appendable,
Serializable {
    private static final long serialVersionUID = -1L;
    private Appendable appendable;
    private CharSequence delimiter;
    private CharSequence prefix;
    private CharSequence suffix;
    private boolean wrapElement;
    private NullMode nullMode = NullMode.NULL_STRING;
    private String emptyResult = "";
    private boolean hasContent;

    public StringJoiner(CharSequence delimiter) {
        this(null, delimiter);
    }

    public StringJoiner(Appendable appendable, CharSequence delimiter) {
        this(appendable, delimiter, null, null);
    }

    public StringJoiner(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        this(null, delimiter, prefix, suffix);
    }

    public StringJoiner(Appendable appendable, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        if (null != appendable) {
            this.appendable = appendable;
            this.checkHasContent(appendable);
        }
        this.delimiter = delimiter;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public static StringJoiner of(StringJoiner joiner) {
        StringJoiner joinerNew = new StringJoiner(joiner.delimiter, joiner.prefix, joiner.suffix);
        joinerNew.wrapElement = joiner.wrapElement;
        joinerNew.nullMode = joiner.nullMode;
        joinerNew.emptyResult = joiner.emptyResult;
        return joinerNew;
    }

    public static StringJoiner of(CharSequence delimiter) {
        return new StringJoiner(delimiter);
    }

    public static StringJoiner of(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return new StringJoiner(delimiter, prefix, suffix);
    }

    public StringJoiner setDelimiter(CharSequence delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public StringJoiner setPrefix(CharSequence prefix) {
        this.prefix = prefix;
        return this;
    }

    public StringJoiner setSuffix(CharSequence suffix) {
        this.suffix = suffix;
        return this;
    }

    public StringJoiner setWrapElement(boolean wrapElement) {
        this.wrapElement = wrapElement;
        return this;
    }

    public StringJoiner setNullMode(NullMode nullMode) {
        this.nullMode = nullMode;
        return this;
    }

    public StringJoiner setEmptyResult(String emptyResult) {
        this.emptyResult = emptyResult;
        return this;
    }

    public StringJoiner append(Object obj) {
        if (null == obj) {
            this.append((CharSequence)null);
        } else if (ArrayKit.isArray(obj)) {
            this.append(new ArrayIterator(obj));
        } else if (obj instanceof Iterator) {
            this.append((Iterator)obj);
        } else if (obj instanceof Iterable) {
            this.append(((Iterable)obj).iterator());
        } else if (obj instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)obj;
            this.append(entry.getKey()).append(entry.getValue());
        } else {
            this.append(ObjectKit.toString(obj));
        }
        return this;
    }

    public <T> StringJoiner append(T[] array) {
        if (null == array) {
            return this;
        }
        return this.append(new ArrayIterator<T>(array));
    }

    public <T> StringJoiner append(Iterator<T> iterator) {
        if (null != iterator) {
            while (iterator.hasNext()) {
                this.append(iterator.next());
            }
        }
        return this;
    }

    public <T> StringJoiner append(T[] array, Function<T, ? extends CharSequence> toStrFunc) {
        return this.append(new ArrayIterator<T>(array), (Function<? super E, ? extends CharSequence>)toStrFunc);
    }

    public <E> StringJoiner append(Iterable<E> iterable, Function<? super E, ? extends CharSequence> toStrFunc) {
        return this.append(IteratorKit.getIter(iterable), toStrFunc);
    }

    public <E> StringJoiner append(Iterator<E> iterator, Function<? super E, ? extends CharSequence> toStrFunc) {
        if (null != iterator) {
            while (iterator.hasNext()) {
                this.append(toStrFunc.apply(iterator.next()));
            }
        }
        return this;
    }

    @Override
    public StringJoiner append(CharSequence csq) {
        return this.append(csq, 0, StringKit.length(csq));
    }

    @Override
    public StringJoiner append(CharSequence csq, int startInclude, int endExclude) {
        if (null == csq) {
            switch (this.nullMode.ordinal()) {
                case 0: {
                    return this;
                }
                case 1: {
                    csq = "";
                    break;
                }
                case 2: {
                    csq = "null";
                    endExclude = "null".length();
                }
            }
        }
        try {
            Appendable appendable = this.prepare();
            if (this.wrapElement && StringKit.isNotEmpty(this.prefix)) {
                appendable.append(this.prefix);
            }
            appendable.append(csq, startInclude, endExclude);
            if (this.wrapElement && StringKit.isNotEmpty(this.suffix)) {
                appendable.append(this.suffix);
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return this;
    }

    @Override
    public StringJoiner append(char c) {
        return this.append(String.valueOf(c));
    }

    public StringJoiner merge(StringJoiner stringJoiner) {
        if (null != stringJoiner && null != stringJoiner.appendable) {
            String otherStr = stringJoiner.toString();
            if (stringJoiner.wrapElement) {
                this.append(otherStr);
            } else {
                this.append(otherStr, this.prefix.length(), otherStr.length());
            }
        }
        return this;
    }

    public int length() {
        return this.appendable != null ? this.appendable.toString().length() + StringKit.length(this.suffix) : (null == this.emptyResult ? -1 : this.emptyResult.length());
    }

    public String toString() {
        if (null == this.appendable) {
            return this.emptyResult;
        }
        Object result = this.appendable.toString();
        if (!this.wrapElement && StringKit.isNotEmpty(this.suffix)) {
            result = (String)result + String.valueOf(this.suffix);
        }
        return result;
    }

    private Appendable prepare() throws IOException {
        if (this.hasContent) {
            if (null != this.delimiter) {
                this.appendable.append(this.delimiter);
            }
        } else {
            if (null == this.appendable) {
                this.appendable = new StringBuilder();
            }
            if (!this.wrapElement && StringKit.isNotEmpty(this.prefix)) {
                this.appendable.append(this.prefix);
            }
            this.hasContent = true;
        }
        return this.appendable;
    }

    private void checkHasContent(Appendable appendable) {
        if (appendable instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)((Object)appendable);
            if (charSequence.length() > 0 && StringKit.endWith(charSequence, this.delimiter)) {
                this.hasContent = true;
            }
        } else {
            String initStr = appendable.toString();
            if (StringKit.isNotEmpty(initStr) && !StringKit.endWith((CharSequence)initStr, this.delimiter)) {
                this.hasContent = true;
            }
        }
    }

    public static enum NullMode {
        IGNORE,
        TO_EMPTY,
        NULL_STRING;

    }
}

