/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.replacer;

import org.miaixz.bus.core.text.replacer.StringReplacer;
import org.miaixz.bus.core.xyz.StringKit;

public class CharRangeReplacer
extends StringReplacer {
    private static final long serialVersionUID = -1L;
    private final int beginInclude;
    private final int endExclude;
    private final char replacedChar;
    private final boolean isCodePoint;

    public CharRangeReplacer(int beginInclude, int endExclude, char replacedChar, boolean isCodePoint) {
        this.beginInclude = beginInclude;
        this.endExclude = endExclude;
        this.replacedChar = replacedChar;
        this.isCodePoint = isCodePoint;
    }

    @Override
    public String apply(CharSequence text) {
        if (StringKit.isEmpty(text)) {
            return StringKit.toString(text);
        }
        String originalStr = StringKit.toString(text);
        int beginInclude = this.beginInclude;
        int[] chars = (this.isCodePoint ? originalStr.codePoints() : originalStr.chars()).toArray();
        int strLength = chars.length;
        if (beginInclude > strLength) {
            return originalStr;
        }
        int endExclude = this.endExclude;
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (beginInclude > endExclude) {
            return originalStr;
        }
        StringBuilder stringBuilder = new StringBuilder(originalStr.length());
        for (int i = 0; i < strLength; ++i) {
            if (i >= beginInclude && i < endExclude) {
                this.replace(originalStr, i, stringBuilder);
                continue;
            }
            this.append(stringBuilder, chars[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected int replace(CharSequence text, int pos, StringBuilder out) {
        out.appendCodePoint(this.replacedChar);
        return pos;
    }

    private void append(StringBuilder stringBuilder, int c) {
        if (this.isCodePoint) {
            stringBuilder.appendCodePoint(c);
        } else {
            stringBuilder.append((char)c);
        }
    }
}

