/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.miaixz.bus.core.beans.BeanDescCache;
import org.miaixz.bus.core.beans.BeanInfoCache;
import org.miaixz.bus.core.beans.DynaBean;
import org.miaixz.bus.core.beans.PropDesc;
import org.miaixz.bus.core.beans.StrictBeanDesc;
import org.miaixz.bus.core.beans.copier.BeanCopier;
import org.miaixz.bus.core.beans.copier.CopyOptions;
import org.miaixz.bus.core.beans.copier.ValueProvider;
import org.miaixz.bus.core.beans.path.BeanPath;
import org.miaixz.bus.core.center.map.CaseInsensitiveMap;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.convert.RecordConverter;
import org.miaixz.bus.core.lang.exception.BeanException;
import org.miaixz.bus.core.lang.mutable.MutableEntry;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ModifierKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.RecordKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.SetKit;
import org.miaixz.bus.core.xyz.StringKit;

public class BeanKit {
    public static DynaBean createDynaBean(Object bean) {
        return new DynaBean(bean);
    }

    public static PropertyEditor findEditor(Class<?> type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static StrictBeanDesc getBeanDesc(Class<?> clazz) {
        return BeanDescCache.INSTANCE.getBeanDesc(clazz, () -> new StrictBeanDesc(clazz));
    }

    public static void descForEach(Class<?> clazz, Consumer<? super PropDesc> action) {
        BeanKit.getBeanDesc(clazz).getProps().forEach(action);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws BeanException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new BeanException(e);
        }
        return ArrayKit.filter(beanInfo.getPropertyDescriptors(), t -> !"class".equals(t.getName()));
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        return BeanInfoCache.INSTANCE.getPropertyDescriptorMap(clazz, ignoreCase, () -> BeanKit.internalGetPropertyDescriptorMap(clazz, ignoreCase));
    }

    private static Map<String, PropertyDescriptor> internalGetPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        PropertyDescriptor[] propertyDescriptors = BeanKit.getPropertyDescriptors(clazz);
        CaseInsensitiveMap<String, PropertyDescriptor> map = ignoreCase ? new CaseInsensitiveMap(propertyDescriptors.length, 1.0f) : new HashMap(propertyDescriptors.length, 1.0f);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) throws BeanException {
        return BeanKit.getPropertyDescriptor(clazz, fieldName, false);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName, boolean ignoreCase) throws BeanException {
        Map<String, PropertyDescriptor> map = BeanKit.getPropertyDescriptorMap(clazz, ignoreCase);
        return null == map ? null : map.get(fieldName);
    }

    public static Object getFieldValue(Object bean, String fieldNameOrIndex) {
        if (null == bean || null == fieldNameOrIndex) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(fieldNameOrIndex);
        }
        if (bean instanceof Collection) {
            try {
                return CollKit.get((Collection)bean, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException e) {
                return CollKit.map((Collection)bean, beanEle -> BeanKit.getFieldValue(beanEle, fieldNameOrIndex), false);
            }
        }
        if (ArrayKit.isArray(bean)) {
            try {
                return ArrayKit.get(bean, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException e) {
                return ArrayKit.map(bean, Object.class, beanEle -> BeanKit.getFieldValue(beanEle, fieldNameOrIndex));
            }
        }
        return FieldKit.getFieldValue(bean, fieldNameOrIndex);
    }

    public static Object setFieldValue(Object bean, String fieldNameOrIndex, Object value) {
        if (bean instanceof Map) {
            ((Map)bean).put(fieldNameOrIndex, value);
        } else if (bean instanceof List) {
            ListKit.setOrPadding((List)bean, Convert.toInt(fieldNameOrIndex), value);
        } else {
            if (ArrayKit.isArray(bean)) {
                return ArrayKit.setOrPadding(bean, Convert.toInt(fieldNameOrIndex), value);
            }
            FieldKit.setFieldValue(bean, fieldNameOrIndex, value);
        }
        return bean;
    }

    public static <T> T getProperty(Object bean, String expression) {
        if (null == bean || StringKit.isBlank(expression)) {
            return null;
        }
        return (T)BeanPath.of(expression).getValue(bean);
    }

    public static void setProperty(Object bean, String expression, Object value) {
        BeanPath.of(expression).setValue(bean, value);
    }

    public static <T> T toBean(Object source, Class<T> clazz) {
        return BeanKit.toBean(source, clazz, null);
    }

    public static <T> T toBean(Object source, Class<T> clazz, CopyOptions options) {
        return (T)BeanKit.toBean(source, () -> ReflectKit.newInstanceIfPossible(clazz), options);
    }

    public static <T> T toBean(Object source, Supplier<T> targetSupplier, CopyOptions options) {
        if (null == source || null == targetSupplier) {
            return null;
        }
        T target = targetSupplier.get();
        BeanKit.copyProperties(source, target, options);
        return target;
    }

    public static <T> T fillBean(T bean, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return bean;
        }
        return BeanCopier.of(valueProvider, bean, copyOptions).copy();
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, CopyOptions copyOptions) {
        if (MapKit.isEmpty(map)) {
            return bean;
        }
        return BeanKit.copyProperties(map, bean, copyOptions);
    }

    public static Map<String, Object> beanToMap(Object bean, String ... properties) {
        int mapSize = 16;
        UnaryOperator editor = null;
        if (ArrayKit.isNotEmpty(properties)) {
            mapSize = properties.length;
            HashSet<String> propertiesSet = SetKit.of(properties);
            editor = entry -> {
                String key = (String)entry.getKey();
                entry.setKey(propertiesSet.contains(key) ? key : null);
                return entry;
            };
        }
        return BeanKit.beanToMap(bean, new LinkedHashMap<String, Object>(mapSize, 1.0f), false, editor);
    }

    public static Map<String, Object> beanToMap(Object bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean) {
            return null;
        }
        return BeanKit.beanToMap(bean, new LinkedHashMap<String, Object>(), isToUnderlineCase, ignoreNullValue);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean) {
            return null;
        }
        return BeanKit.beanToMap(bean, targetMap, ignoreNullValue, entry -> {
            String key = (String)entry.getKey();
            entry.setKey(isToUnderlineCase ? StringKit.toUnderlineCase(key) : key);
            return entry;
        });
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean ignoreNullValue, UnaryOperator<MutableEntry<String, Object>> keyEditor) {
        if (null == bean) {
            return null;
        }
        return BeanCopier.of(bean, targetMap, CopyOptions.of().setIgnoreNullValue(ignoreNullValue).setFieldEditor(keyEditor)).copy();
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, CopyOptions copyOptions) {
        if (null == bean) {
            return null;
        }
        return BeanCopier.of(bean, targetMap, copyOptions).copy();
    }

    public static <T> T copyProperties(Object source, Class<T> tClass, String ... ignoreProperties) {
        if (null == source) {
            return null;
        }
        if (RecordKit.isRecord(tClass)) {
            return (T)RecordConverter.INSTANCE.convert(tClass, source);
        }
        T target = ReflectKit.newInstanceIfPossible(tClass);
        return BeanKit.copyProperties(source, target, CopyOptions.of().setIgnoreProperties(ignoreProperties));
    }

    public static <T> T copyProperties(Object source, T target, String ... ignoreProperties) {
        return BeanKit.copyProperties(source, target, CopyOptions.of().setIgnoreProperties(ignoreProperties));
    }

    public static <T> T copyProperties(Object source, T target, boolean ignoreCase) {
        return BeanCopier.of(source, target, CopyOptions.of().setIgnoreCase(ignoreCase)).copy();
    }

    public static <T> T copyProperties(Object source, T target, CopyOptions copyOptions) {
        if (null == source || null == target) {
            return null;
        }
        return BeanCopier.of(source, target, ObjectKit.defaultIfNull(copyOptions, CopyOptions::of)).copy();
    }

    public static <T> List<T> copyToList(Collection<?> collection, Class<T> targetType) {
        return BeanKit.copyToList(collection, targetType, CopyOptions.of());
    }

    public static <T> List<T> copyToList(Collection<?> collection, Class<T> targetType, CopyOptions copyOptions) {
        if (null == collection) {
            return null;
        }
        if (collection.isEmpty()) {
            return new ArrayList(0);
        }
        if (ClassKit.isBasicType(targetType) || String.class == targetType) {
            return Convert.toList(targetType, collection);
        }
        return collection.stream().map(source -> {
            Object target = ReflectKit.newInstanceIfPossible(targetType);
            BeanKit.copyProperties(source, target, copyOptions);
            return target;
        }).collect(Collectors.toList());
    }

    public static boolean isMatchName(Object bean, String beanClassName, boolean isSimple) {
        if (null == bean || StringKit.isBlank(beanClassName)) {
            return false;
        }
        return ClassKit.getClassName(bean, isSimple).equals(isSimple ? StringKit.upperFirst(beanClassName) : beanClassName);
    }

    public static <T> T edit(T bean, UnaryOperator<Field> editor) {
        Field[] fields;
        if (bean == null) {
            return null;
        }
        for (Field field : fields = FieldKit.getFields(bean.getClass())) {
            if (ModifierKit.isStatic(field)) continue;
            editor.apply(field);
        }
        return bean;
    }

    public static <T> T trimStringField(T bean, String ... ignoreField) {
        return BeanKit.edit(bean, field -> {
            String trimVal;
            String val;
            if (ignoreField != null && ArrayKit.containsIgnoreCase(ignoreField, field.getName())) {
                return field;
            }
            if (String.class.equals(field.getType()) && null != (val = (String)FieldKit.getFieldValue(bean, field)) && !val.equals(trimVal = StringKit.trim(val))) {
                FieldKit.setFieldValue(bean, field, (Object)trimVal);
            }
            return field;
        });
    }

    public static boolean isEmpty(Object bean, String ... ignoreFieldNames) {
        return !BeanKit.isNotEmpty(bean, ignoreFieldNames);
    }

    public static boolean isNotEmpty(Object bean, String ... ignoreFieldNames) {
        if (null == bean) {
            return false;
        }
        return BeanKit.checkBean(bean, field -> !ArrayKit.contains(ignoreFieldNames, field.getName()) && null != FieldKit.getFieldValue(bean, field));
    }

    public static boolean isReadableBean(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return BeanKit.hasGetter(clazz) || BeanKit.hasPublicField(clazz);
    }

    public static boolean isWritableBean(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return BeanKit.hasSetter(clazz) || BeanKit.hasPublicField(clazz);
    }

    public static boolean hasSetter(Class<?> clazz) {
        if (ClassKit.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                if (method.getParameterCount() != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasGetter(Class<?> clazz) {
        if (ClassKit.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                String name;
                if (method.getParameterCount() != 0 || !(name = method.getName()).startsWith("get") && !name.startsWith("is") || "getClass".equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicField(Class<?> clazz) {
        if (ClassKit.isNormalClass(clazz)) {
            for (Field field : clazz.getFields()) {
                if (!ModifierKit.isPublic(field) || ModifierKit.isStatic(field)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNullField(Object bean, String ... ignoreFieldNames) {
        return BeanKit.checkBean(bean, field -> !ArrayKit.contains(ignoreFieldNames, field.getName()) && null == FieldKit.getFieldValue(bean, field));
    }

    public static boolean hasEmptyField(Object bean, String ... ignoreFieldNames) {
        return BeanKit.checkBean(bean, field -> !ArrayKit.contains(ignoreFieldNames, field.getName()) && StringKit.isEmptyIfString(FieldKit.getFieldValue(bean, field)));
    }

    public static boolean checkBean(Object bean, Predicate<Field> predicate) {
        if (null == bean) {
            return true;
        }
        for (Field field : FieldKit.getFields(bean.getClass())) {
            if (ModifierKit.isStatic(field) || !predicate.test(field)) continue;
            return true;
        }
        return false;
    }

    public static String getFieldName(String getterOrSetterName) {
        if (getterOrSetterName.startsWith("get") || getterOrSetterName.startsWith("set")) {
            return StringKit.removePreAndLowerFirst((CharSequence)getterOrSetterName, 3);
        }
        if (getterOrSetterName.startsWith("is")) {
            return StringKit.removePreAndLowerFirst((CharSequence)getterOrSetterName, 2);
        }
        throw new IllegalArgumentException("Invalid Getter or Setter name: " + getterOrSetterName);
    }
}

