/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.miaixz.bus.core.center.function.LambdaFactory;
import org.miaixz.bus.core.center.function.LambdaInfo;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ModifierKit;
import org.miaixz.bus.core.xyz.ReflectKit;

public class LambdaKit {
    private static final WeakConcurrentMap<Object, LambdaInfo> CACHE = new WeakConcurrentMap();

    public static <R, T extends Serializable> Class<R> getRealClass(T func) {
        LambdaInfo lambdaInfo = LambdaKit.resolve(func);
        return (Class)Optional.of(lambdaInfo).map(LambdaInfo::getInstantiatedMethodParameterTypes).filter(types -> ((Type[])types).length != 0).map(types -> types[((Type[])types).length - 1]).orElseGet(lambdaInfo::getClazz);
    }

    public static <T extends Serializable> LambdaInfo resolve(T func) {
        return CACHE.computeIfAbsent(func, key -> {
            SerializedLambda serializedLambda = LambdaKit._resolve(func);
            String methodName = serializedLambda.getImplMethodName();
            Class implClass = ClassKit.loadClass(serializedLambda.getImplClass(), true);
            if ("<init>".equals(methodName)) {
                for (Constructor<?> constructor : implClass.getDeclaredConstructors()) {
                    if (!ReflectKit.getDesc(constructor, false).equals(serializedLambda.getImplMethodSignature())) continue;
                    return new LambdaInfo(constructor, serializedLambda);
                }
            } else {
                Method[] methods;
                for (Method method : methods = MethodKit.getMethods(implClass)) {
                    if (!method.getName().equals(methodName) || !ReflectKit.getDesc(method, false).equals(serializedLambda.getImplMethodSignature())) continue;
                    return new LambdaInfo(method, serializedLambda);
                }
            }
            throw new IllegalStateException("No lambda method found.");
        });
    }

    public static <T extends Serializable> String getMethodName(T func) {
        return LambdaKit.resolve(func).getName();
    }

    public static <T extends Serializable> String getFieldName(T func) throws IllegalArgumentException {
        return BeanKit.getFieldName(LambdaKit.getMethodName(func));
    }

    public static <T, R> Function<T, R> buildGetter(Method getMethod) {
        return LambdaFactory.build(Function.class, getMethod);
    }

    public static <T, R> Function<T, R> buildGetter(Class<T> clazz, String fieldName) {
        return LambdaFactory.build(Function.class, BeanKit.getBeanDesc(clazz).getGetter(fieldName));
    }

    public static <T, P> BiConsumer<T, P> buildSetter(Method setMethod) {
        Class<?> returnType = setMethod.getReturnType();
        if (Void.TYPE == returnType) {
            return LambdaFactory.build(BiConsumer.class, setMethod);
        }
        BiFunction biFunction = LambdaFactory.build(BiFunction.class, setMethod);
        return biFunction::apply;
    }

    public static <T, P> BiConsumer<T, P> buildSetter(Class<T> clazz, String fieldName) {
        return LambdaFactory.build(BiConsumer.class, BeanKit.getBeanDesc(clazz).getSetter(fieldName));
    }

    public static <F> F build(Class<F> lambdaType, Class<?> clazz, String methodName, Class<?> ... paramsTypes) {
        return LambdaFactory.build(lambdaType, clazz, methodName, paramsTypes);
    }

    public static <T, U, R> Function<T, R> toFunction(BiFunction<T, U, R> biFunction, U param) {
        return t -> biFunction.apply(t, param);
    }

    public static <T, U> Predicate<T> toPredicate(BiPredicate<T, U> biPredicate, U param) {
        return t -> biPredicate.test(t, param);
    }

    public static <T, U> Consumer<T> toPredicate(BiConsumer<T, U> biConsumer, U param) {
        return t -> biConsumer.accept(t, param);
    }

    public static Method getInvokeMethod(Class<?> funcType) {
        Method[] abstractMethods = MethodKit.getPublicMethods(funcType, ModifierKit::isAbstract);
        Assert.equals(abstractMethods.length, 1, "Not a function class: " + funcType.getName(), new Object[0]);
        return abstractMethods[0];
    }

    private static <T extends Serializable> SerializedLambda _resolve(T func) {
        if (func instanceof SerializedLambda) {
            return (SerializedLambda)func;
        }
        if (func instanceof Proxy) {
            throw new IllegalArgumentException("not support proxy, just for now");
        }
        Class<?> clazz = func.getClass();
        if (!clazz.isSynthetic()) {
            throw new IllegalArgumentException("Not a lambda expression: " + clazz.getName());
        }
        Object serLambda = MethodKit.invoke(func, "writeReplace", new Object[0]);
        if (serLambda instanceof SerializedLambda) {
            return (SerializedLambda)serLambda;
        }
        throw new InternalException("writeReplace result value is not java.lang.invoke.SerializedLambda");
    }
}

