/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.miaixz.bus.core.center.iterator.EnumerationIterator;
import org.miaixz.bus.core.io.resource.ClassPathResource;
import org.miaixz.bus.core.io.resource.FileResource;
import org.miaixz.bus.core.io.resource.JarResource;
import org.miaixz.bus.core.io.resource.MultiResource;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.io.resource.UrlResource;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Normal;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IteratorKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ResourceKit {
    public static String readString(String resource) {
        return ResourceKit.getResource(resource).readString();
    }

    public static String readString(String resource, Charset charset) {
        return ResourceKit.getResource(resource).readString(charset);
    }

    public static byte[] readBytes(String resource) {
        return ResourceKit.getResource(resource).readBytes();
    }

    public static InputStream getStream(String resource) throws InternalException {
        return ResourceKit.getResource(resource).getStream();
    }

    public static InputStream getStreamSafe(String resource) {
        try {
            return ResourceKit.getResource(resource).getStream();
        }
        catch (InternalException internalException) {
            return null;
        }
    }

    public static BufferedReader getReader(String resource) {
        return ResourceKit.getReader(resource, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static BufferedReader getReader(String resource, Charset charset) {
        return ResourceKit.getResource(resource).getReader(charset);
    }

    public static URL getResourceUrl(String resource) throws InternalException {
        return ResourceKit.getResourceUrl(resource, null);
    }

    public static List<URL> getResourceUrls(String resource) {
        return ResourceKit.getResourceUrls(resource, null);
    }

    public static List<URL> getResourceUrls(String resource, Predicate<URL> filter) {
        return IteratorKit.filterToList(ResourceKit.getResourceUrlIter(resource), filter);
    }

    public static EnumerationIterator<URL> getResourceUrlIter(String resource) {
        return ResourceKit.getResourceUrlIter(resource, null);
    }

    public static EnumerationIterator<URL> getResourceUrlIter(String resource, ClassLoader classLoader) {
        Enumeration<URL> resources;
        try {
            resources = ObjectKit.defaultIfNull(classLoader, ClassKit::getClassLoader).getResources(resource);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return new EnumerationIterator<URL>(resources);
    }

    public static URL getResourceUrl(String resource, Class<?> baseClass) {
        resource = StringKit.emptyIfNull(resource);
        return null != baseClass ? baseClass.getResource(resource) : ClassKit.getClassLoader().getResource(resource);
    }

    public static Resource getResource(String path) {
        if (StringKit.isNotBlank(path) && (path.startsWith("file:") || FileKit.isAbsolutePath(path))) {
            return new FileResource(path);
        }
        return new ClassPathResource(path);
    }

    public static Resource getResource(URL url) {
        if (Normal.isJarURL(url)) {
            return new JarResource(url);
        }
        if (Normal.isFileURL(url)) {
            return new FileResource(url.getFile());
        }
        return new UrlResource(url);
    }

    public static Resource getResource(File file) {
        return new FileResource(file);
    }

    public static MultiResource getResources(String resource) {
        return ResourceKit.getResources(resource, null);
    }

    public static MultiResource getResources(String resource, ClassLoader classLoader) {
        EnumerationIterator<URL> iter = ResourceKit.getResourceUrlIter(resource, classLoader);
        MultiResource resources = new MultiResource(new Resource[0]);
        for (URL url : iter) {
            resources.add(ResourceKit.getResource(url));
        }
        return resources;
    }

    public static void loadTo(Properties properties, Resource resource, Charset charset) {
        block17: {
            Assert.notNull(properties);
            Assert.notNull(resource);
            String filename = resource.getName();
            if (filename != null && StringKit.endWithIgnoreCase(filename, ".xml")) {
                try (InputStream in = resource.getStream();){
                    properties.loadFromXML(in);
                    break block17;
                }
                catch (IOException e) {
                    throw new InternalException(e);
                }
            }
            try (BufferedReader reader = resource.getReader(ObjectKit.defaultIfNull(charset, org.miaixz.bus.core.lang.Charset.UTF_8));){
                properties.load(reader);
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        }
    }

    public static void loadAllTo(Properties properties, String resourceName, ClassLoader classLoader, Charset charset, boolean isOverride) {
        if (isOverride) {
            for (Resource resource : ResourceKit.getResources(resourceName, classLoader)) {
                ResourceKit.loadTo(properties, resource, charset);
            }
            return;
        }
        Properties tmpProps = new Properties();
        for (Resource resource : ResourceKit.getResources(resourceName, classLoader)) {
            ResourceKit.loadTo(tmpProps, resource, charset);
            tmpProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> {
                if (!properties.containsKey(name)) {
                    properties.put(name, value);
                }
            }));
        }
    }
}

