/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.miaixz.bus.core.data.Pid;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;

public class RuntimeKit {
    public static String execForString(String ... cmds) throws InternalException {
        return RuntimeKit.execForString(org.miaixz.bus.core.lang.Charset.systemCharset(), cmds);
    }

    public static String execForString(Charset charset, String ... cmds) throws InternalException {
        return RuntimeKit.getResult(RuntimeKit.exec(cmds), charset);
    }

    public static List<String> execForLines(String ... cmds) throws InternalException {
        return RuntimeKit.execForLines(org.miaixz.bus.core.lang.Charset.systemCharset(), cmds);
    }

    public static List<String> execForLines(Charset charset, String ... cmds) throws InternalException {
        return RuntimeKit.getResultLines(RuntimeKit.exec(cmds), charset);
    }

    public static Process exec(String ... cmds) {
        Process process;
        try {
            process = new ProcessBuilder(RuntimeKit.handleCmds(cmds)).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return process;
    }

    public static Process exec(String[] envp, String ... cmds) {
        return RuntimeKit.exec(envp, null, cmds);
    }

    public static Process exec(String[] envp, File dir, String ... cmds) {
        try {
            return Runtime.getRuntime().exec(RuntimeKit.handleCmds(cmds), envp, dir);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static List<String> getResultLines(Process process) {
        return RuntimeKit.getResultLines(process, org.miaixz.bus.core.lang.Charset.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getResultLines(Process process, Charset charset) {
        List list;
        InputStream in = null;
        try {
            in = process.getInputStream();
            list = IoKit.readLines(in, charset, new ArrayList());
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(in);
            RuntimeKit.destroy(process);
            throw throwable;
        }
        IoKit.closeQuietly(in);
        RuntimeKit.destroy(process);
        return list;
    }

    public static String getResult(Process process) {
        return RuntimeKit.getResult(process, org.miaixz.bus.core.lang.Charset.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResult(Process process, Charset charset) {
        String string;
        InputStream in = null;
        try {
            in = process.getInputStream();
            string = IoKit.read(in, charset);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(in);
            RuntimeKit.destroy(process);
            throw throwable;
        }
        IoKit.closeQuietly(in);
        RuntimeKit.destroy(process);
        return string;
    }

    public static String getErrorResult(Process process) {
        return RuntimeKit.getErrorResult(process, org.miaixz.bus.core.lang.Charset.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorResult(Process process, Charset charset) {
        String string;
        InputStream in = null;
        try {
            in = process.getErrorStream();
            string = IoKit.read(in, charset);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(in);
            RuntimeKit.destroy(process);
            throw throwable;
        }
        IoKit.closeQuietly(in);
        RuntimeKit.destroy(process);
        return string;
    }

    public static void destroy(Process process) {
        if (null != process) {
            process.destroy();
        }
    }

    public static void addShutdownHook(Runnable hook) {
        Runtime.getRuntime().addShutdownHook(hook instanceof Thread ? (Thread)hook : new Thread(hook));
    }

    public static int getProcessorCount() {
        int cpu = Runtime.getRuntime().availableProcessors();
        if (cpu <= 0) {
            cpu = 7;
        }
        return cpu;
    }

    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static long getUsableMemory() {
        return RuntimeKit.getMaxMemory() - RuntimeKit.getTotalMemory() + RuntimeKit.getFreeMemory();
    }

    public static int getPid() throws InternalException {
        return Pid.INSTANCE.get();
    }

    private static String[] handleCmds(String ... cmds) {
        if (ArrayKit.isEmpty(cmds)) {
            throw new NullPointerException("Command is empty !");
        }
        if (1 == cmds.length) {
            String cmd = cmds[0];
            if (StringKit.isBlank(cmd)) {
                throw new NullPointerException("Command is blank !");
            }
            cmds = RuntimeKit.cmdSplit(cmd);
        }
        return cmds;
    }

    private static String[] cmdSplit(String cmd) {
        ArrayList<String> cmds = new ArrayList<String>();
        int length = cmd.length();
        Stack<Character> stack = new Stack<Character>();
        boolean inWrap = false;
        StringBuilder cache = new StringBuilder();
        block4: for (int i = 0; i < length; ++i) {
            char c = cmd.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (inWrap) {
                        if (c == ((Character)stack.peek()).charValue()) {
                            stack.pop();
                            inWrap = false;
                        }
                        cache.append(c);
                        continue block4;
                    }
                    stack.push(Character.valueOf(c));
                    cache.append(c);
                    inWrap = true;
                    continue block4;
                }
                case ' ': {
                    if (inWrap) {
                        cache.append(c);
                        continue block4;
                    }
                    cmds.add(cache.toString());
                    cache.setLength(0);
                    continue block4;
                }
                default: {
                    cache.append(c);
                }
            }
        }
        if (cache.length() > 0) {
            cmds.add(cache.toString());
        }
        return cmds.toArray(new String[0]);
    }
}

