/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import org.miaixz.bus.core.center.function.FunctionPool;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.text.TextSimilarity;
import org.miaixz.bus.core.text.placeholder.StringFormatter;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ObjectKit;

public class StringKit
extends CharsBacker {
    public static boolean isBlankIfString(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StringKit.isBlank((CharSequence)obj);
        }
        return false;
    }

    public static boolean isEmptyIfString(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).length();
        }
        return false;
    }

    public static void trim(String[] args) {
        if (null == args) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            String text = args[i];
            if (null == text) continue;
            args[i] = StringKit.trim(text);
        }
    }

    public static String toString(Object obj) {
        return StringKit.toString(obj, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String toString(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof char[]) {
            return new String((char[])obj);
        }
        if (obj instanceof byte[]) {
            return StringKit.toString((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StringKit.toString((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StringKit.toString((ByteBuffer)obj, charset);
        }
        if (ArrayKit.isArray(obj)) {
            return ArrayKit.toString(obj);
        }
        return obj.toString();
    }

    public static String toString(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String toString(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StringKit.toString(bytes, charset);
    }

    public static String toString(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String toStringOrNull(Object obj) {
        return null == obj ? null : obj.toString();
    }

    public static String toStringOrEmpty(Object obj) {
        return null == obj ? "" : obj.toString();
    }

    public static String stringFast(char[] value) {
        return FunctionPool.createString(value);
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StringReader getReader(CharSequence text) {
        if (null == text) {
            return null;
        }
        return new StringReader(text.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static String reverse(String text) {
        return new String(ArrayKit.reverse(text.toCharArray()));
    }

    public static String fillBefore(String text, char filledChar, int len) {
        return StringKit.fill(text, filledChar, len, true);
    }

    public static String fillAfter(String text, char filledChar, int len) {
        return StringKit.fill(text, filledChar, len, false);
    }

    public static String fill(String text, char filledChar, int len, boolean isPre) {
        int strLen = text.length();
        if (strLen > len) {
            return text;
        }
        String filledStr = StringKit.repeat(filledChar, len - strLen);
        return isPre ? filledStr.concat(text) : text.concat(filledStr);
    }

    public static String fill(int count, char charVal) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater than or equal 0.");
        }
        char[] chs = new char[count];
        for (int i = 0; i < count; ++i) {
            chs[i] = charVal;
        }
        return new String(chs);
    }

    public static String fill(int count, String strVal) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater than or equal 0.");
        }
        StringBuilder sb = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            sb.append(strVal);
        }
        return sb.toString();
    }

    public static double similar(String str1, String str2) {
        return TextSimilarity.similar(str1, str2);
    }

    public static String similar(String str1, String str2, int scale) {
        return TextSimilarity.similar(str1, str2, scale);
    }

    public static String format(CharSequence template, Map<?, ?> map) {
        return StringKit.format(template, map, true);
    }

    public static String format(CharSequence template, Map<?, ?> map, boolean ignoreNull) {
        return StringFormatter.format(template, map, ignoreNull);
    }

    public static boolean hasText(String text) {
        if (null == text || text.isEmpty()) {
            return false;
        }
        int strLen = text.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String build(Object original, String middle, int prefixLength) {
        if (ObjectKit.isNull(original)) {
            return null;
        }
        String string = original.toString();
        int stringLength = string.length();
        String prefix = stringLength >= prefixLength ? string.substring(0, prefixLength) : string.substring(0, stringLength);
        String suffix = "";
        int suffixLength = stringLength - prefix.length() - middle.length();
        if (suffixLength > 0) {
            suffix = string.substring(stringLength - suffixLength);
        }
        return prefix + middle + suffix;
    }

    public static String capitalize(String text) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (null == text || (strLen = text.length()) == 0) {
            return text;
        }
        int firstCodepoint = text.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return text;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = text.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String unCapitalize(String text) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (null == text || (strLen = text.length()) == 0) {
            return text;
        }
        int firstCodepoint = text.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toLowerCase(firstCodepoint))) {
            return text;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = text.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }
}

