/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Normal;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.net.url.RFC3986;
import org.miaixz.bus.core.net.url.UrlEncoder;
import org.miaixz.bus.core.net.url.UrlQuery;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ResourceKit;
import org.miaixz.bus.core.xyz.StringKit;

public class UrlKit {
    public static URL url(URI uri) throws InternalException {
        if (null == uri) {
            return null;
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new InternalException(e);
        }
    }

    public static URL url(String url) {
        return UrlKit.url(url, null);
    }

    public static URL url(String url, URLStreamHandler handler) {
        if (null == url) {
            return null;
        }
        if (url.startsWith("classpath:")) {
            url = url.substring("classpath:".length());
            return ClassKit.getClassLoader().getResource(url);
        }
        try {
            return new URL(null, url, handler);
        }
        catch (MalformedURLException e) {
            if (e.getMessage().contains("Accessing an URL protocol that was not enabled")) {
                throw new InternalException(e);
            }
            try {
                return new File(url).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new InternalException(e);
            }
        }
    }

    public static URI getStringURI(CharSequence content) {
        if (null == content) {
            return null;
        }
        return URI.create(StringKit.addPrefixIfNot(content, "string:///"));
    }

    public static URL toUrlForHttp(String urlStr) {
        return UrlKit.toUrlForHttp(urlStr, null);
    }

    public static URL toUrlForHttp(String urlStr, URLStreamHandler handler) {
        Assert.notBlank(urlStr, "Url is blank !", new Object[0]);
        urlStr = UrlEncoder.encodeBlank(urlStr);
        try {
            return new URL(null, urlStr, handler);
        }
        catch (MalformedURLException e) {
            throw new InternalException(e);
        }
    }

    public static URL getURL(String pathBaseClassLoader) {
        return ResourceKit.getResourceUrl(pathBaseClassLoader);
    }

    public static URL getURL(String path, Class<?> clazz) {
        return ResourceKit.getResourceUrl(path, clazz);
    }

    public static URL getURL(File file) {
        Assert.notNull(file, "File is null !", new Object[0]);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new InternalException(e, "Error occurred when get URL!", new Object[0]);
        }
    }

    public static URL getURL(URL url, String relativePath) throws InternalException {
        relativePath = StringKit.replace((CharSequence)StringKit.removePrefix(relativePath, "/"), (CharSequence)"#", "%23");
        try {
            return new URL(url, relativePath);
        }
        catch (MalformedURLException e) {
            throw new InternalException(e, "Error occurred when get URL!", new Object[0]);
        }
    }

    public static URL[] getURLs(File ... files) {
        URL[] urls = new URL[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new InternalException(e, "Error occurred when get URL!", new Object[0]);
        }
        return urls;
    }

    public static URI getHost(URL url) {
        if (null == url) {
            return null;
        }
        try {
            return new URI(url.getProtocol(), url.getHost(), null, null);
        }
        catch (URISyntaxException e) {
            throw new InternalException(e);
        }
    }

    public static String completeUrl(String baseUrl, String relativePath) {
        if (StringKit.isBlank(baseUrl = UrlKit.normalize(baseUrl, false))) {
            return null;
        }
        try {
            URL absoluteUrl = new URL(baseUrl);
            URL parseUrl = new URL(absoluteUrl, relativePath);
            return parseUrl.toString();
        }
        catch (MalformedURLException e) {
            throw new InternalException(e);
        }
    }

    public static String getPath(String uriStr) {
        return UrlKit.toURI(uriStr).getPath();
    }

    public static String getDecodedPath(URL url) {
        if (null == url) {
            return null;
        }
        String path = null;
        try {
            path = UrlKit.toURI(url).getPath();
        }
        catch (InternalException internalException) {
            // empty catch block
        }
        return null != path ? path : url.getPath();
    }

    public static URI toURI(URL url) throws InternalException {
        return UrlKit.toURI(url, false);
    }

    public static URI toURI(URL url, boolean isEncode) throws InternalException {
        if (null == url) {
            return null;
        }
        return UrlKit.toURI(url.toString(), isEncode);
    }

    public static URI toURI(String location) throws InternalException {
        return UrlKit.toURI(location, false);
    }

    public static URI toURI(String location, boolean isEncode) throws InternalException {
        if (isEncode) {
            location = RFC3986.PATH.encode(location, org.miaixz.bus.core.lang.Charset.UTF_8, new char[0]);
        }
        try {
            return new URI(StringKit.trim(location));
        }
        catch (URISyntaxException e) {
            throw new InternalException(e);
        }
    }

    public static InputStream getStream(URL url) {
        Assert.notNull(url, "URL must be not null", new Object[0]);
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static BufferedReader getReader(URL url, Charset charset) {
        return IoKit.toReader(UrlKit.getStream(url), charset);
    }

    public static String normalize(String url) {
        return UrlKit.normalize(url, false);
    }

    public static String normalize(String url, boolean isEncodePath) {
        return UrlKit.normalize(url, isEncodePath, false);
    }

    public static String normalize(String url, boolean isEncodePath, boolean replaceSlash) {
        String body;
        String protocol;
        if (StringKit.isBlank(url)) {
            return url;
        }
        int sepIndex = url.indexOf("://");
        if (sepIndex > 0) {
            protocol = StringKit.subPre(url, sepIndex + 3);
            body = StringKit.subSuf(url, sepIndex + 3);
        } else {
            protocol = "http://";
            body = url;
        }
        int paramsSepIndex = StringKit.indexOf(body, '?');
        String params = null;
        if (paramsSepIndex > 0) {
            params = StringKit.subSuf(body, paramsSepIndex);
            body = StringKit.subPre(body, paramsSepIndex);
        }
        if (StringKit.isNotEmpty(body)) {
            body = body.replaceAll("^[\\\\/]+", "");
            body = body.replace("\\", "/");
            if (replaceSlash) {
                body = body.replaceAll("//+", "/");
            }
        }
        int pathSepIndex = StringKit.indexOf(body, '/');
        String domain = body;
        String path = null;
        if (pathSepIndex > 0) {
            domain = StringKit.subPre(body, pathSepIndex);
            path = StringKit.subSuf(body, pathSepIndex);
        }
        if (isEncodePath) {
            path = RFC3986.PATH.encode(path, org.miaixz.bus.core.lang.Charset.UTF_8, new char[0]);
        }
        return protocol + domain + StringKit.emptyIfNull(path) + StringKit.emptyIfNull(params);
    }

    public static String buildQuery(Map<String, ?> paramMap, Charset charset) {
        return UrlQuery.of(paramMap).build(charset);
    }

    public static String getDataUriBase64(String mimeType, String data) {
        return UrlKit.getDataUri(mimeType, null, "base64", data);
    }

    public static String getDataUri(String mimeType, String encoding, String data) {
        return UrlKit.getDataUri(mimeType, null, encoding, data);
    }

    public static String getDataUri(String mimeType, Charset charset, String encoding, String data) {
        StringBuilder builder = StringKit.builder((CharSequence)"data:");
        if (StringKit.isNotBlank(mimeType)) {
            builder.append(mimeType);
        }
        if (null != charset) {
            builder.append(";charset=").append(charset.name());
        }
        if (StringKit.isNotBlank(encoding)) {
            builder.append(';').append(encoding);
        }
        builder.append(',').append(data);
        return builder.toString();
    }

    public static long size(URL url) {
        if (Normal.isFileOrVfsURL(url)) {
            File file = FileKit.file(url);
            long length = file.length();
            if (length == 0L && !file.exists()) {
                throw new InternalException("File not exist or size is zero!");
            }
            return length;
        }
        URLConnection conn = null;
        try {
            conn = url.openConnection();
            UrlKit.useCachesIfNecessary(conn);
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection httpCon = (HttpURLConnection)conn;
                httpCon.setRequestMethod("HEAD");
            }
            long httpCon = conn.getContentLengthLong();
            return httpCon;
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        finally {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
    }

    public static void useCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getSimpleName().startsWith("JNLP"));
    }

    public static String toQuery(Map<String, ?> paramMap) {
        return UrlKit.toQuery(paramMap, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String toQuery(Map<String, ?> paramMap, Charset charset) {
        return UrlKit.toQuery(paramMap, charset, null);
    }

    public static String toQuery(Map<String, ?> paramMap, Charset charset, UrlQuery.EncodeMode encodeMode) {
        return UrlQuery.of(paramMap, encodeMode).build(charset);
    }

    public static String encodeQuery(String urlWithParams, Charset charset) {
        String paramPart;
        if (StringKit.isBlank(urlWithParams)) {
            return "";
        }
        String urlPart = null;
        int pathEndPos = urlWithParams.indexOf(63);
        if (pathEndPos > -1) {
            urlPart = StringKit.subPre(urlWithParams, pathEndPos);
            paramPart = StringKit.subSuf(urlWithParams, pathEndPos + 1);
            if (StringKit.isBlank(paramPart)) {
                return urlPart;
            }
        } else {
            if (!StringKit.contains((CharSequence)urlWithParams, '=')) {
                return urlWithParams;
            }
            paramPart = urlWithParams;
        }
        paramPart = UrlKit.normalizeQuery(paramPart, charset);
        return StringKit.isBlank(urlPart) ? paramPart : urlPart + "?" + paramPart;
    }

    public static String normalizeQuery(String queryPart, Charset charset) {
        int lastIndex;
        int i;
        if (StringKit.isEmpty(queryPart)) {
            return queryPart;
        }
        StringBuilder builder = new StringBuilder(queryPart.length() + 16);
        int len = queryPart.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = queryPart.charAt(i);
            if (c == '=') {
                if (null != name) continue;
                name = pos == i ? "" : queryPart.substring(pos, i);
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (pos != i) {
                if (null == name) {
                    name = queryPart.substring(pos, i);
                    builder.append(RFC3986.QUERY_PARAM_NAME.encode(name, charset, new char[0])).append('=');
                } else {
                    builder.append(RFC3986.QUERY_PARAM_NAME.encode(name, charset, new char[0])).append('=').append(RFC3986.QUERY_PARAM_VALUE.encode(queryPart.substring(pos, i), charset, new char[0])).append('&');
                }
                name = null;
            }
            pos = i + 1;
        }
        if (null != name) {
            builder.append(UrlEncoder.encodeQuery(name, charset)).append('=');
        }
        if (pos != i) {
            if (null == name && pos > 0) {
                builder.append('=');
            }
            builder.append(UrlEncoder.encodeQuery(queryPart.substring(pos, i), charset));
        }
        if ('&' == builder.charAt(lastIndex = builder.length() - 1)) {
            builder.delete(lastIndex, builder.length());
        }
        return builder.toString();
    }

    public static Map<String, String> decodeQuery(String paramsStr, Charset charset) {
        Map<CharSequence, CharSequence> queryMap = UrlQuery.of(paramsStr, charset).getQueryMap();
        if (MapKit.isEmpty(queryMap)) {
            return MapKit.empty();
        }
        return Convert.toMap(String.class, String.class, queryMap);
    }

    public static Map<String, List<String>> decodeQueryList(String paramsStr, Charset charset) {
        Map<CharSequence, CharSequence> queryMap = UrlQuery.of(paramsStr, charset).getQueryMap();
        if (MapKit.isEmpty(queryMap)) {
            return MapKit.empty();
        }
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        queryMap.forEach((key, value) -> {
            List values = params.computeIfAbsent(StringKit.toString(key), k -> new ArrayList(1));
            values.add(StringKit.toString(value));
        });
        return params;
    }
}

