/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.cache.file;

import java.io.File;
import java.io.Serializable;
import org.miaixz.bus.core.cache.Cache;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;

public abstract class AbstractFileCache
implements Serializable {
    private static final long serialVersionUID = -1L;
    protected final int capacity;
    protected final int maxFileSize;
    protected final long timeout;
    protected final Cache<File, byte[]> cache;
    protected int usedSize;

    public AbstractFileCache(int capacity, int maxFileSize, long timeout) {
        this.capacity = capacity;
        this.maxFileSize = maxFileSize;
        this.timeout = timeout;
        this.cache = this.initCache();
    }

    public int capacity() {
        return this.capacity;
    }

    public int getUsedSize() {
        return this.usedSize;
    }

    public int maxFileSize() {
        return this.maxFileSize;
    }

    public int getCachedFilesCount() {
        return this.cache.size();
    }

    public long timeout() {
        return this.timeout;
    }

    public void clear() {
        this.cache.clear();
        this.usedSize = 0;
    }

    public byte[] getFileBytes(String path) throws InternalException {
        return this.getFileBytes(new File(path));
    }

    public byte[] getFileBytes(File file) throws InternalException {
        byte[] bytes = this.cache.get(file);
        if (bytes != null) {
            return bytes;
        }
        bytes = FileKit.readBytes(file);
        if (this.maxFileSize != 0 && file.length() > (long)this.maxFileSize) {
            return bytes;
        }
        this.usedSize += bytes.length;
        this.cache.put(file, bytes);
        return bytes;
    }

    protected abstract Cache<File, byte[]> initCache();
}

