/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.cache.provider;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.miaixz.bus.core.cache.provider.CacheObject;
import org.miaixz.bus.core.cache.provider.StampedCache;

public class FIFOCache<K, V>
extends StampedCache<K, V> {
    private static final long serialVersionUID = -1L;

    public FIFOCache(int capacity) {
        this(capacity, 0L);
    }

    public FIFOCache(int capacity, long timeout) {
        this.capacity = capacity;
        this.timeout = timeout;
        this.cacheMap = new LinkedHashMap(capacity + 1, 1.0f, false);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        CacheObject first = null;
        Iterator values = this.cacheObjIter();
        if (this.isPruneExpiredActive()) {
            while (values.hasNext()) {
                CacheObject co = values.next();
                if (co.isExpired()) {
                    values.remove();
                    this.onRemove(co.key, co.obj);
                    ++count;
                    continue;
                }
                if (first != null) continue;
                first = co;
            }
        } else {
            CacheObject cacheObject = first = values.hasNext() ? values.next() : null;
        }
        if (this.isFull() && null != first) {
            this.removeWithoutLock(first.key);
            this.onRemove(first.key, first.obj);
            ++count;
        }
        return count;
    }
}

