/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.cache.provider;

import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import org.miaixz.bus.core.cache.provider.AbstractCache;
import org.miaixz.bus.core.cache.provider.CacheObject;
import org.miaixz.bus.core.cache.provider.CacheObjectIterator;
import org.miaixz.bus.core.center.iterator.CopiedIterator;

public abstract class ReentrantCache<K, V>
extends AbstractCache<K, V> {
    private static final long serialVersionUID = -1L;
    protected final ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V object, long timeout) {
        this.lock.lock();
        try {
            this.putWithoutLock(key, object, timeout);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean containsKey(K key) {
        return null != this.getOrRemoveExpired(key, false, false);
    }

    @Override
    public V get(K key, boolean isUpdateLastAccess) {
        return this.getOrRemoveExpired(key, isUpdateLastAccess, true);
    }

    @Override
    public Iterator<CacheObject<K, V>> cacheObjIterator() {
        CopiedIterator copiedIterator;
        this.lock.lock();
        try {
            copiedIterator = CopiedIterator.copyOf(this.cacheObjIter());
        }
        finally {
            this.lock.unlock();
        }
        return new CacheObjectIterator(copiedIterator);
    }

    @Override
    public final int prune() {
        this.lock.lock();
        try {
            int n = this.pruneCache();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remove(K key) {
        CacheObject co;
        this.lock.lock();
        try {
            co = this.removeWithoutLock(key);
        }
        finally {
            this.lock.unlock();
        }
        if (null != co) {
            this.onRemove(co.key, co.obj);
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        this.lock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getOrRemoveExpired(K key, boolean isUpdateLastAccess, boolean isUpdateCount) {
        CacheObject co;
        this.lock.lock();
        try {
            co = this.getWithoutLock(key);
            if (null != co && co.isExpired()) {
                this.removeWithoutLock(key);
                co = null;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (null == co) {
            if (isUpdateCount) {
                this.missCount.increment();
            }
            return null;
        }
        if (isUpdateCount) {
            this.hitCount.increment();
        }
        return co.get(isUpdateLastAccess);
    }
}

