/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.en;

import java.time.DayOfWeek;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.EnumKit;

public enum Week {
    SUNDAY(1, "\u65e5"),
    MONDAY(2, "\u4e00"),
    TUESDAY(3, "\u4e8c"),
    WEDNESDAY(4, "\u4e09"),
    THURSDAY(5, "\u56db"),
    FRIDAY(6, "\u4e94"),
    SATURDAY(7, "\u516d");

    private static final Week[] ENUMS;
    private final int code;
    private final String name;

    private Week(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static Week of(int code) {
        if (code > ENUMS.length || code < 1) {
            return null;
        }
        return ENUMS[code - 1];
    }

    public static Week of(String name) throws IllegalArgumentException {
        if (null != name && name.length() > 1) {
            switch (Character.toLowerCase(name.charAt(0))) {
                case 'm': {
                    return MONDAY;
                }
                case 'w': {
                    return WEDNESDAY;
                }
                case 'f': {
                    return FRIDAY;
                }
                case 't': {
                    switch (Character.toLowerCase(name.charAt(1))) {
                        case 'u': {
                            return TUESDAY;
                        }
                        case 'h': {
                            return THURSDAY;
                        }
                    }
                    break;
                }
                case 's': {
                    switch (Character.toLowerCase(name.charAt(1))) {
                        case 'a': {
                            return SATURDAY;
                        }
                        case 'u': {
                            return SUNDAY;
                        }
                    }
                }
            }
        }
        throw new IllegalArgumentException("Invalid Week name: " + name);
    }

    public static Week of(DayOfWeek dayOfWeek) {
        Assert.notNull(dayOfWeek);
        int week = dayOfWeek.getValue() + 1;
        if (8 == week) {
            week = 1;
        }
        return Week.of(week);
    }

    public static String getName(int code, String prefix) {
        return prefix + Week.ENUMS[code].name;
    }

    public static String[] get(String fieldName) {
        return (String[])EnumKit.getFieldValues(Week.class, fieldName).toArray(String[]::new);
    }

    public int getCode() {
        return this.code;
    }

    public int getIsoValue() {
        int iso8601IntValue = this.getCode() - 1;
        if (0 == iso8601IntValue) {
            iso8601IntValue = 7;
        }
        return iso8601IntValue;
    }

    public String getName() {
        return this.name;
    }

    public String getName(String prefix) {
        switch (this.ordinal()) {
            case 0: {
                return prefix + "\u65e5";
            }
            case 1: {
                return prefix + "\u4e00";
            }
            case 2: {
                return prefix + "\u4e8c";
            }
            case 3: {
                return prefix + "\u4e09";
            }
            case 4: {
                return prefix + "\u56db";
            }
            case 5: {
                return prefix + "\u4e94";
            }
            case 6: {
                return prefix + "\u516d";
            }
        }
        return null;
    }

    public DayOfWeek toJdkDayOfWeek() {
        return DayOfWeek.of(this.getIsoValue());
    }

    static {
        ENUMS = Week.values();
    }
}

