/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.iterator;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.miaixz.bus.core.center.iterator.IterableIterator;
import org.miaixz.bus.core.center.iterator.ResettableIterator;

public class ArrayIterator<E>
implements IterableIterator<E>,
ResettableIterator<E>,
Serializable {
    private static final long serialVersionUID = -1L;
    private final Object array;
    private int startIndex;
    private int endIndex;
    private int index;

    public ArrayIterator(E[] array) {
        this((Object)array);
    }

    public ArrayIterator(Object array) {
        this(array, 0);
    }

    public ArrayIterator(Object array, int startIndex) {
        this(array, startIndex, -1);
    }

    public ArrayIterator(Object array, int startIndex, int endIndex) {
        this.endIndex = Array.getLength(Objects.requireNonNull(array));
        if (endIndex > 0 && endIndex < this.endIndex) {
            this.endIndex = endIndex;
        }
        if (startIndex >= 0 && startIndex < this.endIndex) {
            this.startIndex = startIndex;
        }
        this.array = array;
        this.index = this.startIndex;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.endIndex;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (E)Array.get(this.array, this.index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported");
    }

    public Object getArray() {
        return this.array;
    }

    @Override
    public void reset() {
        this.index = this.startIndex;
    }
}

