/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.convert.AbstractConverter;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.StringKit;

public class XMLGregorianCalendarConverter
extends AbstractConverter {
    private static final long serialVersionUID = -1L;
    private final DatatypeFactory datatypeFactory;
    private String format;

    public XMLGregorianCalendarConverter() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new DateException(e);
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected XMLGregorianCalendar convertInternal(Class<?> targetClass, Object value) {
        if (value instanceof GregorianCalendar) {
            return this.datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)value);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (value instanceof Date) {
            gregorianCalendar.setTime((Date)value);
        } else if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            gregorianCalendar.setTimeZone(calendar.getTimeZone());
            gregorianCalendar.setFirstDayOfWeek(calendar.getFirstDayOfWeek());
            gregorianCalendar.setLenient(calendar.isLenient());
            gregorianCalendar.setTimeInMillis(calendar.getTimeInMillis());
        } else if (value instanceof Long) {
            gregorianCalendar.setTimeInMillis((Long)value);
        } else {
            DateTime date;
            String valueStr = this.convertToString(value);
            DateTime dateTime = date = StringKit.isBlank(this.format) ? DateKit.parse(valueStr) : DateKit.parse((CharSequence)valueStr, this.format);
            if (null == date) {
                throw new ConvertException("Unsupported date value: " + String.valueOf(value));
            }
            gregorianCalendar.setTime(date);
        }
        return this.datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
    }
}

