/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.data;

import java.time.Year;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.core.center.regex.Pattern;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.PatternKit;

public class VIN {
    private static final int[] WEIGHT = new int[]{8, 7, 6, 5, 4, 3, 2, 10, 0, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final int YEAR_LOOP = 30;
    private static final char[] YEAR_ID = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final Map<Character, Integer> YEAR_MAP;
    private final String code;

    public VIN(String vinCode) {
        Assert.isTrue(VIN.verify(vinCode), "Invalid VIN code!", new Object[0]);
        this.code = vinCode;
    }

    public static VIN of(String vinCode) {
        return new VIN(vinCode);
    }

    public static boolean verify(String vinCode) {
        Assert.notBlank(vinCode, "VIN code must be not blank!", new Object[0]);
        if (!PatternKit.isMatch(Pattern.CAR_VIN_PATTERN, (CharSequence)vinCode)) {
            return false;
        }
        return vinCode.charAt(8) == VIN.calculateVerifyCode(vinCode);
    }

    private static char calculateVerifyCode(String vinCode) {
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            sum += VIN.getWeightFactor(vinCode, i);
        }
        int factor = sum % 11;
        return factor != 10 ? (char)(factor + 48) : (char)'X';
    }

    private static int getWeightFactor(String vinCode, int i) {
        char c = vinCode.charAt(i);
        return VIN.getVinValue(c) * WEIGHT[i];
    }

    private static int getVinValue(char vinCodeChar) {
        switch (vinCodeChar) {
            case '0': {
                return 0;
            }
            case '1': 
            case 'A': 
            case 'J': {
                return 1;
            }
            case '2': 
            case 'B': 
            case 'K': 
            case 'S': {
                return 2;
            }
            case '3': 
            case 'C': 
            case 'L': 
            case 'T': {
                return 3;
            }
            case '4': 
            case 'D': 
            case 'M': 
            case 'U': {
                return 4;
            }
            case '5': 
            case 'E': 
            case 'N': 
            case 'V': {
                return 5;
            }
            case '6': 
            case 'F': 
            case 'W': {
                return 6;
            }
            case '7': 
            case 'G': 
            case 'P': 
            case 'X': {
                return 7;
            }
            case '8': 
            case 'H': 
            case 'Y': {
                return 8;
            }
            case '9': 
            case 'R': 
            case 'Z': {
                return 9;
            }
        }
        throw new IllegalArgumentException("Invalid VIN char: " + vinCodeChar);
    }

    public String getCode() {
        return this.code;
    }

    public String getCountryCode() {
        return this.code.substring(0, 2);
    }

    public String getWMI() {
        String wmi = this.code.substring(0, 3);
        return this.isLessThan1000() ? wmi + this.code.substring(11, 14) : wmi;
    }

    public boolean isLessThan1000() {
        return '9' == this.code.charAt(2);
    }

    public String getVDS() {
        return this.code.substring(3, 9);
    }

    public String getVehicleDescriptorCode() {
        return this.code.substring(3, 8);
    }

    public String getVIS() {
        return this.code.substring(9);
    }

    public Year getYear() {
        return this.getYear(1);
    }

    public char getOemCode() {
        return this.code.charAt(10);
    }

    public Year getYear(int multiple) {
        int year = 1980 + 30 * multiple + YEAR_MAP.get(Character.valueOf(this.code.charAt(9))) % 30;
        return Year.of(year);
    }

    public String getProdNo() {
        return this.code.substring(this.isLessThan1000() ? 14 : 11, 17);
    }

    static {
        HashMap<Character, Integer> yearMap = new HashMap<Character, Integer>(YEAR_ID.length, 1.0f);
        for (int i = 0; i < YEAR_ID.length; ++i) {
            yearMap.put(Character.valueOf(YEAR_ID[i]), i);
        }
        YEAR_MAP = MapKit.view(yearMap);
    }
}

