/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.miaixz.bus.core.io.compress.ZipResource;
import org.miaixz.bus.core.io.compress.ZipSecurity;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.ZipKit;

public class ZipFileResource
implements ZipResource {
    private final ZipFile zipFile;

    public ZipFileResource(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public void read(Consumer<ZipEntry> consumer, int maxSizeDiff) {
        Enumeration<? extends ZipEntry> em = this.zipFile.entries();
        while (em.hasMoreElements()) {
            consumer.accept(ZipSecurity.checkZipBomb(em.nextElement(), maxSizeDiff));
        }
    }

    @Override
    public InputStream get(String path) {
        ZipFile zipFile = this.zipFile;
        ZipEntry entry = zipFile.getEntry(path);
        if (null != entry) {
            return ZipKit.getStream(zipFile, entry);
        }
        return null;
    }

    @Override
    public InputStream get(ZipEntry entry) {
        return ZipKit.getStream(this.zipFile, entry);
    }

    @Override
    public void close() throws IOException {
        IoKit.closeQuietly(this.zipFile);
    }
}

